<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IcaEnrollment extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'surname',
        'first_name',
        'email',
        'mobile',
        'age',
        'address',
        'city',
        'educational_level',
        'enrollment_fee',
        'programs_of_interest',
        'payment_status',
        'payment_method',
        'payment_reference',
        'bank_receipt_path',
        'payment_verified_at',
        'verified_by',
        'admin_notes',
        'enrollment_status',
        'has_previous_experience',
        'work_experience'
    ];

    protected $casts = [
        'programs_of_interest' => 'array',
        'payment_verified_at' => 'datetime',
        'enrollment_fee' => 'decimal:2'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function verifier()
    {
        return $this->belongsTo(User::class, 'verified_by');
    }

    public function programs()
    {
        $programCodes = $this->programs_of_interest;
        return IcaProgram::whereIn('program_code', $programCodes)->get();
    }
}
