<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IcaProgram extends Model
{
    use HasFactory;

    protected $fillable = [
        'category',
        'program_name',
        'program_code',
        'price',
        'description',
        'requirements',
        'benefits',
        'certification',
        'is_active',
        'duration_weeks',
        'location'
    ];

    protected $casts = [
        'price' => 'decimal:2',
        'is_active' => 'boolean'
    ];

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeByCategory($query, $category)
    {
        return $query->where('category', $category);
    }
}
