<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('ica_enrollments', function (Blueprint $table) {
            $table->id();
            $table->string('surname');
            $table->string('first_name');
            $table->string('email');
            $table->string('mobile');
            $table->integer('age');
            $table->text('address');
            $table->string('city');
            $table->enum('educational_level', ['SHS/TVET', 'DIPLOMA/DEGREE', 'MASTERS', 'OTHER']);
            $table->decimal('enrollment_fee', 10, 2)->default(100.00);
            $table->json('programs_of_interest');
            $table->enum('payment_status', ['pending', 'paid', 'rejected'])->default('pending');
            $table->enum('payment_method', ['paystack', 'bank_transfer', 'mobile_money'])->nullable();
            $table->string('payment_reference')->nullable();
            $table->string('bank_receipt_path')->nullable();
            $table->timestamp('payment_verified_at')->nullable();
            $table->unsignedBigInteger('verified_by')->nullable();
            $table->text('admin_notes')->nullable();
            $table->enum('enrollment_status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->boolean('has_previous_experience')->default(false);
            $table->text('work_experience')->nullable();
            $table->timestamps();
            
            $table->index('email');
            $table->index('payment_status');
            $table->index('enrollment_status');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('ica_enrollments');
    }
};
