<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\IcaProgram;

class IcaProgramSeeder extends Seeder
{
    public function run(): void
    {
        $programs = [
            [
                'category' => 'PROJECT MANAGEMENT',
                'program_name' => 'Microsoft Project Training Program',
                'program_code' => 'MS_PROJECT',
                'price' => 1500.00,
                'description' => 'The Microsoft Project Training Program at Industry Connect Academy (ICA) equips participants with practical skills to efficiently plan, schedule, execute, and monitor projects using Microsoft Project software. The course focuses on real-world project management applications in Event management, engineering, construction, oil & gas, and manufacturing industries.',
                'requirements' => 'Basic computer literacy; Background or interest in project management, events, engineering, or construction, IT; Laptop with Microsoft Project installed (version 2016 or later)',
                'benefits' => 'Gain practical skills in planning and executing projects efficiently; Boost employability in Events, engineering, oil & gas, construction, and ICT sectors; Improve project documentation and reporting accuracy; Earn a professional certificate recognized by ICA industry partners',
                'certification' => 'ICA Certificate in Microsoft Project Management',
                'duration_weeks' => 4,
                'location' => 'On-site',
                'is_active' => true
            ],
            [
                'category' => 'HEIGHT WORKS & ACCESS OPERATIONS',
                'program_name' => 'Work at Height Training',
                'program_code' => 'WORK_HEIGHT',
                'price' => 2000.00,
                'description' => 'Comprehensive training in height work safety, fall prevention, and access operations for industrial environments.',
                'requirements' => 'Minimum age: 18 years; Basic literacy and numeracy; Medically fit for height work; PPE: safety boots, gloves, helmet, harness',
                'benefits' => 'Employable as Rigger, Lifting Technician, Height Safety Officer, Maintenance Technician; Hands-on training in industrial lifting and fall protection; Recognized certification for local and international projects; Pathway to advanced courses like Rope Access',
                'certification' => 'Certificate of Competence in Access Rigging & Height Safety (ICA)',
                'duration_weeks' => 2,
                'location' => 'On-site',
                'is_active' => true
            ],
            [
                'category' => 'HEIGHT WORKS & ACCESS OPERATIONS',
                'program_name' => 'Scaffold Erectors Training',
                'program_code' => 'SCAFFOLD_ERECT',
                'price' => 2000.00,
                'description' => 'Professional training in scaffold erection, inspection, and safety procedures for construction and industrial sites.',
                'requirements' => 'Minimum age: 18 years; Basic literacy and numeracy; Medically fit for height work; PPE: safety boots, gloves, helmet, harness',
                'benefits' => 'Employable as Scaffold Erector, Safety Inspector; Hands-on training in scaffold systems; Industry-recognized certification',
                'certification' => 'Certificate of Competence in Scaffold Erection (ICA)',
                'duration_weeks' => 2,
                'location' => 'On-site',
                'is_active' => true
            ],
            [
                'category' => 'HEIGHT WORKS & ACCESS OPERATIONS',
                'program_name' => 'Scaffold Inspectors Training',
                'program_code' => 'SCAFFOLD_INSPECT',
                'price' => 2000.00,
                'description' => 'Specialized training for scaffold inspection, safety compliance, and quality assurance.',
                'requirements' => 'Minimum age: 18 years; Basic literacy and numeracy; Medically fit for height work; PPE: safety boots, gloves, helmet, harness',
                'benefits' => 'Employable as Scaffold Inspector, Safety Officer; Professional certification; Enhanced safety knowledge',
                'certification' => 'Certificate of Competence in Scaffold Inspection (ICA)',
                'duration_weeks' => 2,
                'location' => 'On-site',
                'is_active' => true
            ],
            [
                'category' => 'HEIGHT WORKS & ACCESS OPERATIONS',
                'program_name' => 'Special Bundle: Any 2 Height Work Programs',
                'program_code' => 'HEIGHT_BUNDLE_2',
                'price' => 3500.00,
                'description' => 'Choose any 2 methods together and save GHS 500',
                'requirements' => 'Minimum age: 18 years; Basic literacy and numeracy; Medically fit for height work; PPE: safety boots, gloves, helmet, harness',
                'benefits' => 'Save GHS 500; Comprehensive training; Multiple certifications',
                'certification' => 'Multiple ICA Certificates',
                'duration_weeks' => 4,
                'location' => 'On-site',
                'is_active' => true
            ],
            [
                'category' => 'CORROSION PROTECTION & SURFACE COATING',
                'program_name' => 'Industrial Coating',
                'program_code' => 'IND_COATING',
                'price' => 6000.00,
                'description' => 'Specialized training in surface preparation, coating application, and corrosion control techniques used in industrial, marine, and oil & gas environments.',
                'requirements' => 'Minimum age: 18 years; Basic literacy and numeracy; Medically fit for industrial environments; PPE: helmet, gloves, respirator, boots, coverall',
                'benefits' => 'Builds technical skills for industrial surface treatment; Enables employment as Coating Applicator or Painting Technician; Provides globally recognized foundation for AMPP or FROSIO certification; Enhances job readiness for offshore, marine, and plant maintenance projects',
                'certification' => 'Certificate of Competence in Industrial Coating (ICA)',
                'duration_weeks' => 4,
                'location' => 'On-site',
                'is_active' => true
            ],
            [
                'category' => 'CORROSION PROTECTION & SURFACE COATING',
                'program_name' => 'Abrasive Blasting',
                'program_code' => 'ABRASIVE_BLAST',
                'price' => 4500.00,
                'description' => 'Professional training in grit blasting, surface preparation, and protective coating systems.',
                'requirements' => 'Minimum age: 18 years; Basic literacy and numeracy; Medically fit for industrial environments; PPE: helmet, gloves, respirator, boots, coverall',
                'benefits' => 'Employment as Blaster; Technical skills in surface treatment; Industry certification',
                'certification' => 'Certificate of Competence in Industrial Blasting (ICA)',
                'duration_weeks' => 3,
                'location' => 'On-site',
                'is_active' => true
            ],
            [
                'category' => 'CORROSION PROTECTION & SURFACE COATING',
                'program_name' => 'Special Bundle: Any 2 Coating Programs',
                'program_code' => 'COATING_BUNDLE_2',
                'price' => 9000.00,
                'description' => 'Choose any 2 methods together and save GHS 1,500',
                'requirements' => 'Minimum age: 18 years; Basic literacy and numeracy; Medically fit for industrial environments; PPE: helmet, gloves, respirator, boots, coverall',
                'benefits' => 'Save GHS 1,500; Comprehensive training; Multiple certifications',
                'certification' => 'Multiple ICA Certificates',
                'duration_weeks' => 7,
                'location' => 'On-site',
                'is_active' => true
            ],
            [
                'category' => 'NON-DESTRUCTIVE TESTING (NDT)',
                'program_name' => 'Visual Testing (VT) - ASNT Level II',
                'program_code' => 'NDT_VT',
                'price' => 5000.00,
                'description' => 'Professional training in visual inspection techniques following ASNT SNT-TC-1A Level II standards.',
                'requirements' => 'Minimum age: 18 years; Basic literacy and numeracy; Basic science background (helpful); Medically fit with good vision (near and color)',
                'benefits' => 'Employable as NDT Technician, Quality Inspector; Foundation for advanced NDT methods; Recognized qualification in inspection',
                'certification' => 'ASNT SNT-TC-1A Level II (ICA) - Visual Testing',
                'duration_weeks' => 3,
                'location' => 'On-site',
                'is_active' => true
            ],
            [
                'category' => 'NON-DESTRUCTIVE TESTING (NDT)',
                'program_name' => 'Dye Penetrant Testing (DPI) - ASNT Level II',
                'program_code' => 'NDT_DPI',
                'price' => 5000.00,
                'description' => 'Professional training in penetrant testing methods following ASNT SNT-TC-1A Level II standards.',
                'requirements' => 'Minimum age: 18 years; Basic literacy and numeracy; Basic science background (helpful); Medically fit with good vision',
                'benefits' => 'Employable as NDT Technician; Professional certification; Enhanced inspection skills',
                'certification' => 'ASNT SNT-TC-1A Level II (ICA) - Dye Penetrant Testing',
                'duration_weeks' => 3,
                'location' => 'On-site',
                'is_active' => true
            ],
            [
                'category' => 'NON-DESTRUCTIVE TESTING (NDT)',
                'program_name' => 'Magnetic Particle Testing (MPI) - ASNT Level II',
                'program_code' => 'NDT_MPI',
                'price' => 5000.00,
                'description' => 'Professional training in magnetic particle inspection following ASNT SNT-TC-1A Level II standards.',
                'requirements' => 'Minimum age: 18 years; Basic literacy and numeracy; Basic science background (helpful); Medically fit with good vision',
                'benefits' => 'Employable as NDT Technician; Professional certification; Industry-recognized qualification',
                'certification' => 'ASNT SNT-TC-1A Level II (ICA) - Magnetic Particle Testing',
                'duration_weeks' => 3,
                'location' => 'On-site',
                'is_active' => true
            ],
            [
                'category' => 'NON-DESTRUCTIVE TESTING (NDT)',
                'program_name' => 'Ultrasonic Testing (UT) - ASNT Level II',
                'program_code' => 'NDT_UT',
                'price' => 5000.00,
                'description' => 'Advanced training in ultrasonic testing techniques following ASNT SNT-TC-1A Level II standards.',
                'requirements' => 'Minimum age: 18 years; Basic literacy and numeracy; Basic science background (helpful); Medically fit with good vision',
                'benefits' => 'Employable as NDT Technician; Advanced inspection skills; High-demand certification',
                'certification' => 'ASNT SNT-TC-1A Level II (ICA) - Ultrasonic Testing',
                'duration_weeks' => 4,
                'location' => 'On-site',
                'is_active' => true
            ],
            [
                'category' => 'NON-DESTRUCTIVE TESTING (NDT)',
                'program_name' => 'Special Bundle: Any 3 NDT Methods',
                'program_code' => 'NDT_BUNDLE_3',
                'price' => 12500.00,
                'description' => 'Choose any 3 methods together and save GHS 2,500',
                'requirements' => 'Minimum age: 18 years; Basic literacy and numeracy; Basic science background (helpful); Medically fit with good vision',
                'benefits' => 'Save GHS 2,500; Comprehensive NDT training; Multiple ASNT certifications; Enhanced employability',
                'certification' => 'Multiple ASNT SNT-TC-1A Level II Certificates (ICA)',
                'duration_weeks' => 9,
                'location' => 'On-site',
                'is_active' => true
            ],
            [
                'category' => 'OCCUPATIONAL HEALTH, SAFETY & ENVIRONMENT (HSE)',
                'program_name' => 'OH&S and the Law for Supervisors',
                'program_code' => 'HSE_OHS_LAW',
                'price' => 0.00,
                'description' => 'Essential knowledge and competencies to maintain safe workplaces, prevent incidents, and ensure compliance with national and international safety standards.',
                'requirements' => 'Minimum age: 18 years; Supervisory or management role preferred; Basic literacy and communication skills',
                'benefits' => 'Strengthens understanding of legal duties and compliance; Enhances supervisory capability and leadership in safety management; Employable as Safety Supervisor or Compliance Officer',
                'certification' => 'Certificate in OH&S and the Law for Supervisors (ICA)',
                'duration_weeks' => 2,
                'location' => 'On-site',
                'is_active' => true
            ],
            [
                'category' => 'OCCUPATIONAL HEALTH, SAFETY & ENVIRONMENT (HSE)',
                'program_name' => 'Laboratory Safety - International',
                'program_code' => 'HSE_LAB_SAFETY',
                'price' => 0.00,
                'description' => 'Comprehensive training in laboratory safety protocols, chemical handling, and emergency procedures following international standards.',
                'requirements' => 'Minimum age: 18 years; Basic literacy and communication skills; Laboratory or science background preferred',
                'benefits' => 'Enhanced laboratory safety knowledge; International certification; Employable as Laboratory Safety Officer',
                'certification' => 'Certificate in Laboratory Safety (ICA)',
                'duration_weeks' => 2,
                'location' => 'On-site',
                'is_active' => true
            ],
            [
                'category' => 'OCCUPATIONAL HEALTH, SAFETY & ENVIRONMENT (HSE)',
                'program_name' => 'Warehouse Safety',
                'program_code' => 'HSE_WAREHOUSE',
                'price' => 0.00,
                'description' => 'Training in warehouse operations safety, material handling, and logistics safety management.',
                'requirements' => 'Minimum age: 18 years; Basic literacy and communication skills; Warehouse or logistics experience preferred',
                'benefits' => 'Warehouse safety expertise; Risk management skills; Employable as Warehouse Safety Officer',
                'certification' => 'Certificate in Warehouse Safety (ICA)',
                'duration_weeks' => 2,
                'location' => 'On-site',
                'is_active' => true
            ],
            [
                'category' => 'OCCUPATIONAL HEALTH, SAFETY & ENVIRONMENT (HSE)',
                'program_name' => 'Contractor Safety',
                'program_code' => 'HSE_CONTRACTOR',
                'price' => 0.00,
                'description' => 'Specialized training in contractor safety management, permit systems, and site safety coordination.',
                'requirements' => 'Minimum age: 18 years; Supervisory or management role preferred; Basic literacy and communication skills',
                'benefits' => 'Contractor safety management expertise; Enhanced compliance knowledge; Employable as Safety Coordinator',
                'certification' => 'Certificate in Contractor Safety (ICA)',
                'duration_weeks' => 2,
                'location' => 'On-site',
                'is_active' => true
            ],
            [
                'category' => 'OCCUPATIONAL HEALTH, SAFETY & ENVIRONMENT (HSE)',
                'program_name' => 'Safety Audits',
                'program_code' => 'HSE_AUDITS',
                'price' => 0.00,
                'description' => 'Professional training in conducting safety audits, compliance assessments, and safety management system evaluation.',
                'requirements' => 'Minimum age: 18 years; Supervisory or management role preferred; Basic literacy and communication skills',
                'benefits' => 'Safety audit expertise; Professional certification; Employable as Safety Auditor',
                'certification' => 'Certificate in Safety Audits (ICA)',
                'duration_weeks' => 2,
                'location' => 'On-site',
                'is_active' => true
            ],
            [
                'category' => 'OCCUPATIONAL HEALTH, SAFETY & ENVIRONMENT (HSE)',
                'program_name' => 'Transportation of Dangerous Goods by Road',
                'program_code' => 'HSE_DG_ROAD',
                'price' => 0.00,
                'description' => 'Training in safe transportation of dangerous goods by road, including regulations, documentation, and emergency response.',
                'requirements' => 'Minimum age: 18 years; Valid driver\'s license preferred; Basic literacy and communication skills',
                'benefits' => 'DG transportation expertise; Regulatory compliance knowledge; Employable as DG Transport Officer',
                'certification' => 'Certificate in Transportation of Dangerous Goods by Road (ICA)',
                'duration_weeks' => 2,
                'location' => 'On-site',
                'is_active' => true
            ],
            [
                'category' => 'OCCUPATIONAL HEALTH, SAFETY & ENVIRONMENT (HSE)',
                'program_name' => 'Transportation of Dangerous Goods by Sea',
                'program_code' => 'HSE_DG_SEA',
                'price' => 0.00,
                'description' => 'Training in safe maritime transportation of dangerous goods following IMDG Code and international regulations.',
                'requirements' => 'Minimum age: 18 years; Maritime or logistics background preferred; Basic literacy and communication skills',
                'benefits' => 'Maritime DG expertise; IMDG Code knowledge; Employable as Maritime Safety Officer',
                'certification' => 'Certificate in Transportation of Dangerous Goods by Sea (ICA)',
                'duration_weeks' => 2,
                'location' => 'On-site',
                'is_active' => true
            ],
            [
                'category' => 'OCCUPATIONAL HEALTH, SAFETY & ENVIRONMENT (HSE)',
                'program_name' => 'Transportation of Dangerous Goods by Air',
                'program_code' => 'HSE_DG_AIR',
                'price' => 0.00,
                'description' => 'Training in safe air transportation of dangerous goods following IATA regulations and international standards.',
                'requirements' => 'Minimum age: 18 years; Aviation or logistics background preferred; Basic literacy and communication skills',
                'benefits' => 'Aviation DG expertise; IATA regulations knowledge; Employable as Aviation Safety Officer',
                'certification' => 'Certificate in Transportation of Dangerous Goods by Air (ICA)',
                'duration_weeks' => 2,
                'location' => 'On-site',
                'is_active' => true
            ]
        ];

        foreach ($programs as $program) {
            IcaProgram::create($program);
        }
    }
}
