@extends('layouts.admin')
@push('title', 'ICA Program Categories')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex align-items-center justify-content-between mb-4">
            <h4 class="fw-bold mb-0">
                <i class="fi-rr-apps me-2"></i>
                ICA Program Categories
            </h4>
            <a href="{{ route('admin.ica.programs') }}" class="btn ol-btn-primary">
                <i class="fi-rr-graduation-cap me-2"></i>Manage Programs
            </a>
        </div>
    </div>
</div>

<!-- Stats Cards -->
<div class="row g-3 mb-4">
    <div class="col-xl-3 col-lg-6 col-md-6">
        <div class="card border-0" style="background: linear-gradient(135deg, #11273f 0%, #1a3a5f 100%);">
            <div class="card-body p-4">
                <div class="d-flex align-items-center justify-content-between">
                    <div>
                        <p class="text-white-50 mb-2 fw-500">Total Categories</p>
                        <h2 class="text-white fw-bold mb-0">{{ count($categories) }}</h2>
                    </div>
                    <div style="background: rgba(255, 255, 255, 0.2); color: white;" class="rounded-3 p-3">
                        <i class="fi-rr-apps fs-3"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-lg-6 col-md-6">
        <div class="card border-0" style="background: linear-gradient(135deg, #f2862d 0%, #ff9f4d 100%);">
            <div class="card-body p-4">
                <div class="d-flex align-items-center justify-content-between">
                    <div>
                        <p class="text-white-50 mb-2 fw-500">Total Programs</p>
                        <h2 class="text-white fw-bold mb-0">{{ $total_programs }}</h2>
                    </div>
                    <div style="background: rgba(255, 255, 255, 0.2); color: white;" class="rounded-3 p-3">
                        <i class="fi-rr-graduation-cap fs-3"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-lg-6 col-md-6">
        <div class="card border-0 bg-success">
            <div class="card-body p-4">
                <div class="d-flex align-items-center justify-content-between">
                    <div>
                        <p class="text-white-50 mb-2 fw-500">Active Programs</p>
                        <h2 class="text-white fw-bold mb-0">{{ \App\Models\IcaProgram::where('is_active', 1)->count() }}</h2>
                    </div>
                    <div class="bg-white bg-opacity-25 rounded-3 p-3">
                        <i class="fi-rr-check-circle fs-3 text-white"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-lg-6 col-md-6">
        <div class="card border-0 bg-info">
            <div class="card-body p-4">
                <div class="d-flex align-items-center justify-content-between">
                    <div>
                        <p class="text-white-50 mb-2 fw-500">Enrollments</p>
                        <h2 class="text-white fw-bold mb-0">{{ \App\Models\IcaEnrollment::count() }}</h2>
                    </div>
                    <div class="bg-white bg-opacity-25 rounded-3 p-3">
                        <i class="fi-rr-users fs-3 text-white"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Categories Grid -->
<div class="row g-4">
    @forelse($categories as $category)
    <div class="col-lg-4 col-md-6">
        <div class="card h-100 category-card-elegant">
            <div class="card-body p-4">
                <div class="d-flex align-items-start justify-content-between mb-3">
                    <div class="category-icon-elegant">
                        <i class="fi-rr-folder-open"></i>
                    </div>
                    <span class="badge bg-primary">{{ $category['count'] }} Programs</span>
                </div>
                
                <h5 class="fw-bold text-navy mb-3">{{ $category['name'] }}</h5>
                
                <div class="category-stats mb-3">
                    <div class="d-flex align-items-center gap-2 mb-2">
                        <i class="fi-rr-check-circle text-success"></i>
                        <span class="text-muted small">{{ $category['active_count'] }} Active Programs</span>
                    </div>
                    <div class="d-flex align-items-center gap-2">
                        <i class="fi-rr-graduation-cap text-primary"></i>
                        <span class="text-muted small">{{ $category['count'] }} Total Programs</span>
                    </div>
                </div>
                
                <div class="program-list-preview">
                    <p class="text-muted small mb-2 fw-600">Programs in this category:</p>
                    <ul class="list-unstyled mb-0">
                        @foreach($category['programs']->take(3) as $program)
                        <li class="mb-1">
                            <i class="fi-rr-angle-small-right text-primary me-1"></i>
                            <small class="text-muted">{{ $program->program_name }}</small>
                        </li>
                        @endforeach
                        @if($category['programs']->count() > 3)
                        <li class="mt-2">
                            <small class="text-primary fw-600">+{{ $category['programs']->count() - 3 }} more...</small>
                        </li>
                        @endif
                    </ul>
                </div>
                
                <div class="mt-3 pt-3 border-top">
                    <a href="{{ route('admin.ica.programs') }}" class="btn btn-sm btn-outline-primary w-100">
                        <i class="fi-rr-eye me-2"></i>View Programs
                    </a>
                </div>
            </div>
        </div>
    </div>
    @empty
    <div class="col-12">
        <div class="card">
            <div class="card-body text-center py-5">
                <i class="fi-rr-apps fs-1 text-muted mb-3 d-block"></i>
                <h5 class="text-muted">No Categories Found</h5>
                <p class="text-muted mb-4">Categories will appear here once you add ICA programs</p>
                <a href="{{ route('admin.ica.programs') }}" class="btn ol-btn-primary">
                    <i class="fi-rr-plus me-2"></i>Add Program
                </a>
            </div>
        </div>
    </div>
    @endforelse
</div>

<!-- Category Summary Table -->
@if(count($categories) > 0)
<div class="card mt-4">
    <div class="card-header bg-white border-bottom">
        <h5 class="mb-0 fw-bold text-navy">
            <i class="fi-rr-list me-2 text-primary"></i>
            Category Summary
        </h5>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="bg-light">
                    <tr>
                        <th class="ps-4" width="5%">#</th>
                        <th width="40%">Category Name</th>
                        <th width="20%">Total Programs</th>
                        <th width="20%">Active Programs</th>
                        <th width="15%" class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($categories as $index => $category)
                    <tr>
                        <td class="ps-4">{{ $index + 1 }}</td>
                        <td>
                            <div class="d-flex align-items-center gap-2">
                                <div class="category-icon-small">
                                    <i class="fi-rr-folder-open text-primary"></i>
                                </div>
                                <span class="fw-600 text-navy">{{ $category['name'] }}</span>
                            </div>
                        </td>
                        <td>
                            <span class="badge bg-primary bg-opacity-10 text-primary">
                                {{ $category['count'] }} Programs
                            </span>
                        </td>
                        <td>
                            <span class="badge bg-success bg-opacity-10 text-success">
                                {{ $category['active_count'] }} Active
                            </span>
                        </td>
                        <td class="text-center">
                            <a href="{{ route('admin.ica.programs') }}" class="btn btn-sm btn-light">
                                <i class="fi-rr-eye me-1"></i>View
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endif

@endsection

@push('css')
<style>
    .category-card-elegant {
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        border: 1px solid #e8eaed;
        position: relative;
        overflow: hidden;
    }
    
    .category-card-elegant::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(90deg, #f2862d, #ff9f4d);
        transform: scaleX(0);
        transform-origin: left;
        transition: transform 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    }
    
    .category-card-elegant:hover {
        border-color: rgba(242, 134, 45, 0.3);
        box-shadow: 0 12px 32px rgba(17, 39, 63, 0.1);
        transform: translateY(-6px);
    }
    
    .category-card-elegant:hover::before {
        transform: scaleX(1);
    }
    
    .category-icon-elegant {
        width: 60px;
        height: 60px;
        background: linear-gradient(135deg, #f2862d, #ff9f4d);
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 1.5rem;
        box-shadow: 0 4px 12px rgba(242, 134, 45, 0.25);
    }
    
    .category-icon-small {
        width: 35px;
        height: 35px;
        background: rgba(242, 134, 45, 0.1);
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1rem;
    }
    
    .text-navy {
        color: #11273f;
    }
    
    .table thead th {
        font-weight: 600;
        font-size: 0.85rem;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        color: #11273f;
    }
    
    .table tbody tr {
        transition: all 0.2s ease;
    }
    
    .table tbody tr:hover {
        background-color: rgba(242, 134, 45, 0.05);
    }
    
    .program-list-preview ul li {
        padding: 4px 0;
    }
    
    .category-stats i {
        font-size: 0.9rem;
    }
</style>
@endpush
