@extends('layouts.admin')
@push('title', 'Enrollment Details')
@section('content')

<div class="row">
    <div class="col-12">
        <div class="page-title-box d-flex align-items-center justify-content-between">
            <h4 class="mb-0">Enrollment Details - ICA-{{ str_pad($enrollment->id, 6, '0', STR_PAD_LEFT) }}</h4>
            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('admin.ica.enrollments') }}">ICA Enrollments</a></li>
                    <li class="breadcrumb-item active">Details</li>
                </ol>
            </div>
        </div>
    </div>
</div>

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        {{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

<div class="row">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Personal Information</h5>
            </div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-6">
                        <strong>Surname:</strong>
                        <p>{{ $enrollment->surname }}</p>
                    </div>
                    <div class="col-md-6">
                        <strong>First Name:</strong>
                        <p>{{ $enrollment->first_name }}</p>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-6">
                        <strong>Email:</strong>
                        <p>{{ $enrollment->email }}</p>
                    </div>
                    <div class="col-md-6">
                        <strong>Mobile:</strong>
                        <p>{{ $enrollment->mobile }}</p>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-4">
                        <strong>Age:</strong>
                        <p>{{ $enrollment->age }}</p>
                    </div>
                    <div class="col-md-8">
                        <strong>City:</strong>
                        <p>{{ $enrollment->city }}</p>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-12">
                        <strong>Address:</strong>
                        <p>{{ $enrollment->address }}</p>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-12">
                        <strong>Educational Level:</strong>
                        <p><span class="badge bg-info">{{ $enrollment->educational_level }}</span></p>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Work Experience</h5>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <strong>Has Previous Experience:</strong>
                    <p>
                        @if($enrollment->has_previous_experience)
                            <span class="badge bg-success">Yes</span>
                        @else
                            <span class="badge bg-secondary">No</span>
                        @endif
                    </p>
                </div>
                <div>
                    <strong>Work Experience Details:</strong>
                    <p class="text-muted">{{ $enrollment->work_experience }}</p>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Selected Programs</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Program Name</th>
                                <th>Category</th>
                                <th>Price</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($programs as $program)
                            <tr>
                                <td>{{ $program->program_name }}</td>
                                <td>{{ $program->category }}</td>
                                <td>GHS {{ number_format($program->price, 2) }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Status</h5>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <strong>Payment Status:</strong>
                    <p>
                        @if($enrollment->payment_status == 'paid')
                            <span class="badge bg-success">Paid</span>
                        @elseif($enrollment->payment_status == 'rejected')
                            <span class="badge bg-danger">Rejected</span>
                        @else
                            <span class="badge bg-warning">Pending</span>
                        @endif
                    </p>
                </div>
                <div class="mb-3">
                    <strong>Enrollment Status:</strong>
                    <p>
                        @if($enrollment->enrollment_status == 'approved')
                            <span class="badge bg-success">Approved</span>
                        @elseif($enrollment->enrollment_status == 'rejected')
                            <span class="badge bg-danger">Rejected</span>
                        @else
                            <span class="badge bg-secondary">Pending</span>
                        @endif
                    </p>
                </div>
                <div class="mb-3">
                    <strong>Enrollment Fee:</strong>
                    <p class="h5 text-success">GHS {{ number_format($enrollment->enrollment_fee, 2) }}</p>
                </div>
                <div class="mb-3">
                    <strong>Submission Date:</strong>
                    <p>{{ $enrollment->created_at->format('d M Y, h:i A') }}</p>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Payment Information</h5>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <strong>Payment Method:</strong>
                    <p>
                        @if($enrollment->payment_method == 'paystack')
                            <i class="fas fa-mobile-alt"></i> Paystack (Mobile Money)
                        @elseif($enrollment->payment_method == 'bank_transfer')
                            <i class="fas fa-university"></i> Bank Transfer
                        @else
                            <i class="fas fa-money-bill-wave"></i> Mobile Money
                        @endif
                    </p>
                </div>
                @if($enrollment->payment_reference)
                <div class="mb-3">
                    <strong>Payment Reference:</strong>
                    <p><code>{{ $enrollment->payment_reference }}</code></p>
                </div>
                @endif
                @if($enrollment->bank_receipt_path)
                <div class="mb-3">
                    <strong>Payment Receipt:</strong>
                    <p>
                        <a href="{{ asset('storage/' . $enrollment->bank_receipt_path) }}" target="_blank" class="btn btn-sm btn-info">
                            <i class="fas fa-download"></i> View Receipt
                        </a>
                    </p>
                </div>
                @endif
                @if($enrollment->payment_verified_at)
                <div class="mb-3">
                    <strong>Verified At:</strong>
                    <p>{{ $enrollment->payment_verified_at->format('d M Y, h:i A') }}</p>
                </div>
                @endif
            </div>
        </div>

        @if($enrollment->payment_status == 'pending' && ($enrollment->payment_method == 'bank_transfer' || $enrollment->payment_method == 'mobile_money'))
        <div class="card border-warning">
            <div class="card-header bg-warning text-white">
                <h5 class="card-title mb-0">Payment Actions</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.ica.enrollment.approve-payment', $enrollment->id) }}" method="POST" class="mb-2">
                    @csrf
                    <div class="mb-2">
                        <label class="form-label">Admin Notes (Optional)</label>
                        <textarea name="admin_notes" class="form-control" rows="2"></textarea>
                    </div>
                    <button type="submit" class="btn btn-success w-100" onclick="return confirm('Approve this payment?')">
                        <i class="fas fa-check"></i> Approve Payment
                    </button>
                </form>
                <form action="{{ route('admin.ica.enrollment.reject-payment', $enrollment->id) }}" method="POST">
                    @csrf
                    <div class="mb-2">
                        <label class="form-label">Rejection Reason</label>
                        <textarea name="admin_notes" class="form-control" rows="2" required></textarea>
                    </div>
                    <button type="submit" class="btn btn-danger w-100" onclick="return confirm('Reject this payment?')">
                        <i class="fas fa-times"></i> Reject Payment
                    </button>
                </form>
            </div>
        </div>
        @endif

        @if($enrollment->payment_status == 'paid' && $enrollment->enrollment_status == 'pending')
        <div class="card border-success">
            <div class="card-header bg-success text-white">
                <h5 class="card-title mb-0">Enrollment Actions</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.ica.enrollment.approve', $enrollment->id) }}" method="POST" class="mb-2">
                    @csrf
                    <button type="submit" class="btn btn-success w-100" onclick="return confirm('Approve this enrollment?')">
                        <i class="fas fa-check-circle"></i> Approve Enrollment
                    </button>
                </form>
                <form action="{{ route('admin.ica.enrollment.reject', $enrollment->id) }}" method="POST">
                    @csrf
                    <div class="mb-2">
                        <label class="form-label">Rejection Reason</label>
                        <textarea name="admin_notes" class="form-control" rows="2" required></textarea>
                    </div>
                    <button type="submit" class="btn btn-danger w-100" onclick="return confirm('Reject this enrollment?')">
                        <i class="fas fa-times-circle"></i> Reject Enrollment
                    </button>
                </form>
            </div>
        </div>
        @endif

        @if($enrollment->admin_notes)
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Admin Notes</h5>
            </div>
            <div class="card-body">
                <p class="text-muted">{{ $enrollment->admin_notes }}</p>
            </div>
        </div>
        @endif
    </div>
</div>

@endsection
