@extends('layouts.default')
@push('title', 'Register - Industry Connect Academy')
@push('meta')@endpush
@push('css')
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
<style>
    :root {
        --ghana-red: #CE1126;
        --ghana-gold: #FCD116;
        --ghana-green: #006B3F;
    }

    * {
        font-family: 'Inter', sans-serif;
    }

    body {
        background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
        min-height: 100vh;
    }

    .ica-register-container {
        min-height: 100vh;
        display: flex;
        align-items: center;
        padding: 40px 0;
    }

    .ica-register-card {
        background: white;
        border-radius: 24px;
        box-shadow: 0 20px 60px rgba(0, 0, 0, 0.1);
        overflow: hidden;
        max-width: 1100px;
        margin: 0 auto;
    }

    .ica-register-left {
        background: linear-gradient(135deg, var(--ghana-green) 0%, #00a651 100%);
        padding: 60px;
        color: white;
        position: relative;
        overflow: hidden;
    }

    .ica-register-left::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(to right, var(--ghana-red), var(--ghana-gold), var(--ghana-green));
    }

    .ica-register-left::after {
        content: '';
        position: absolute;
        bottom: -50px;
        right: -50px;
        width: 200px;
        height: 200px;
        background: rgba(255, 255, 255, 0.1);
        border-radius: 50%;
    }

    .ica-register-logo {
        height: 60px;
        margin-bottom: 30px;
        filter: brightness(0) invert(1);
    }

    .ica-register-left h2 {
        font-size: 2.5rem;
        font-weight: 800;
        margin-bottom: 20px;
        text-shadow: 2px 2px 4px rgba(0,0,0,0.2);
    }

    .ica-register-left p {
        font-size: 1.1rem;
        opacity: 0.95;
        line-height: 1.8;
        margin-bottom: 30px;
    }

    .ica-benefit-list {
        list-style: none;
        padding: 0;
        margin: 30px 0;
    }

    .ica-benefit-list li {
        padding: 15px 0;
        display: flex;
        align-items: center;
        gap: 15px;
        font-size: 1rem;
    }

    .ica-benefit-list li i {
        width: 40px;
        height: 40px;
        background: rgba(255, 255, 255, 0.2);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.2rem;
    }

    .ica-register-right {
        padding: 60px;
    }

    .ica-register-header {
        text-align: center;
        margin-bottom: 40px;
    }

    .ica-register-header h3 {
        font-size: 2rem;
        font-weight: 800;
        color: var(--ghana-green);
        margin-bottom: 10px;
    }

    .ica-register-header p {
        color: #666;
        font-size: 1rem;
    }

    .ica-form-group {
        margin-bottom: 25px;
    }

    .ica-form-label {
        font-weight: 600;
        color: #333;
        margin-bottom: 10px;
        display: block;
        font-size: 0.95rem;
    }

    .ica-form-control {
        width: 100%;
        padding: 14px 18px;
        border: 2px solid #e0e0e0;
        border-radius: 12px;
        font-size: 1rem;
        transition: all 0.3s;
        background: #fafafa;
    }

    .ica-form-control:focus {
        outline: none;
        border-color: var(--ghana-green);
        background: white;
        box-shadow: 0 0 0 4px rgba(0, 107, 63, 0.1);
    }

    .ica-password-wrapper {
        position: relative;
    }

    .ica-password-toggle {
        position: absolute;
        right: 15px;
        top: 50%;
        transform: translateY(-50%);
        background: none;
        border: none;
        color: #666;
        cursor: pointer;
        font-size: 1.2rem;
        padding: 5px;
    }

    .ica-password-toggle:hover {
        color: var(--ghana-green);
    }

    .ica-btn-register {
        width: 100%;
        padding: 15px;
        background: linear-gradient(135deg, var(--ghana-green), #00a651);
        color: white;
        border: none;
        border-radius: 12px;
        font-weight: 700;
        font-size: 1.1rem;
        cursor: pointer;
        transition: all 0.3s;
        box-shadow: 0 5px 20px rgba(0, 107, 63, 0.3);
    }

    .ica-btn-register:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 30px rgba(0, 107, 63, 0.4);
    }

    .ica-btn-register:active {
        transform: translateY(0);
    }

    .ica-divider {
        text-align: center;
        margin: 30px 0;
        position: relative;
    }

    .ica-divider::before {
        content: '';
        position: absolute;
        left: 0;
        right: 0;
        top: 50%;
        height: 1px;
        background: #e0e0e0;
    }

    .ica-divider span {
        background: white;
        padding: 0 15px;
        position: relative;
        color: #999;
        font-size: 0.9rem;
    }

    .ica-login-link {
        text-align: center;
        margin-top: 25px;
        font-size: 1rem;
        color: #666;
    }

    .ica-login-link a {
        color: var(--ghana-green);
        font-weight: 700;
        text-decoration: none;
        transition: all 0.3s;
    }

    .ica-login-link a:hover {
        color: var(--ghana-gold);
    }

    .ica-alert {
        padding: 15px 20px;
        border-radius: 12px;
        margin-bottom: 25px;
        display: flex;
        align-items: center;
        gap: 12px;
        font-size: 0.95rem;
    }

    .ica-alert-info {
        background: #e3f2fd;
        border-left: 4px solid #2196f3;
        color: #1565c0;
    }

    .ica-alert i {
        font-size: 1.3rem;
    }

    .ica-stats {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 20px;
        margin-top: 40px;
    }

    .ica-stat-item {
        text-align: center;
        padding: 20px;
        background: rgba(255, 255, 255, 0.1);
        border-radius: 12px;
    }

    .ica-stat-number {
        font-size: 2rem;
        font-weight: 800;
        display: block;
        margin-bottom: 5px;
    }

    .ica-stat-label {
        font-size: 0.85rem;
        opacity: 0.9;
    }

    @media (max-width: 991px) {
        .ica-register-left {
            padding: 40px;
        }
        .ica-register-right {
            padding: 40px;
        }
        .ica-register-left h2 {
            font-size: 2rem;
        }
    }

    @media (max-width: 767px) {
        .ica-register-left {
            padding: 30px;
        }
        .ica-register-right {
            padding: 30px;
        }
        .ica-stats {
            grid-template-columns: 1fr;
            gap: 15px;
        }
    }
</style>
@endpush

@section('content')
<div class="ica-register-container">
    <div class="container">
        <div class="ica-register-card">
            <div class="row g-0">
                <!-- Left Side - Branding -->
                <div class="col-lg-5 d-none d-lg-block">
                    <div class="ica-register-left">
                        <img src="{{ get_image(get_frontend_settings('light_logo')) }}" alt="ICA Logo" class="ica-register-logo">
                        
                        <h2>Join ICA Today!</h2>
                        <p>Create your account and get instant access to Ghana's premier industrial training programs.</p>
                        
                        <ul class="ica-benefit-list">
                            <li>
                                <i class="fas fa-graduation-cap"></i>
                                <span>21 Professional Training Programs</span>
                            </li>
                            <li>
                                <i class="fas fa-certificate"></i>
                                <span>International Certifications</span>
                            </li>
                            <li>
                                <i class="fas fa-users"></i>
                                <span>Expert Instructors</span>
                            </li>
                            <li>
                                <i class="fas fa-tools"></i>
                                <span>100% Practical Training</span>
                            </li>
                            <li>
                                <i class="fas fa-mobile-alt"></i>
                                <span>Flexible Payment Options</span>
                            </li>
                        </ul>

                        <div class="ica-stats">
                            <div class="ica-stat-item">
                                <span class="ica-stat-number">5</span>
                                <span class="ica-stat-label">Categories</span>
                            </div>
                            <div class="ica-stat-item">
                                <span class="ica-stat-number">21+</span>
                                <span class="ica-stat-label">Programs</span>
                            </div>
                            <div class="ica-stat-item">
                                <span class="ica-stat-number">500+</span>
                                <span class="ica-stat-label">Students</span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Right Side - Register Form -->
                <div class="col-lg-7">
                    <div class="ica-register-right">
                        <div class="ica-register-header">
                            <h3>Create Your Account</h3>
                            <p>Fill in your details to get started with ICA</p>
                        </div>

                        @if(request()->has('redirect') && request()->redirect == 'enrollment')
                            <div class="ica-alert ica-alert-info">
                                <i class="fas fa-graduation-cap"></i>
                                <span><strong>Create your account to enroll in ICA training programs</strong></span>
                            </div>
                        @endif

                        @if(session('error'))
                            <div class="alert alert-danger">
                                <i class="fas fa-exclamation-triangle me-2"></i>{{ session('error') }}
                            </div>
                        @endif

                        <form action="{{ route('register') }}" method="POST" id="ica-register-form" enctype="multipart/form-data">
                            @csrf

                            <div class="ica-form-group">
                                <label for="name" class="ica-form-label">Full Name</label>
                                <input type="text" id="name" name="name" class="ica-form-control" 
                                       placeholder="Enter your full name" required autofocus
                                       value="{{ old('name') }}">
                                @error('name')
                                    <small class="text-danger mt-1 d-block">{{ $message }}</small>
                                @enderror
                            </div>

                            <div class="ica-form-group">
                                <label for="email" class="ica-form-label">Email Address</label>
                                <input type="email" id="email" name="email" class="ica-form-control" 
                                       placeholder="your.email@example.com" required
                                       value="{{ old('email') }}">
                                @error('email')
                                    <small class="text-danger mt-1 d-block">{{ $message }}</small>
                                @enderror
                            </div>

                            <div class="ica-form-group">
                                <label for="password" class="ica-form-label">Password</label>
                                <div class="ica-password-wrapper">
                                    <input type="password" id="password" name="password" class="ica-form-control" 
                                           placeholder="Create a strong password" required>
                                    <button type="button" class="ica-password-toggle" onclick="togglePassword('password', 'password-icon')">
                                        <i class="fas fa-eye" id="password-icon"></i>
                                    </button>
                                </div>
                                <small class="text-muted">Minimum 8 characters</small>
                                @error('password')
                                    <small class="text-danger mt-1 d-block">{{ $message }}</small>
                                @enderror
                            </div>

                            <div class="ica-form-group">
                                <label for="password_confirmation" class="ica-form-label">Confirm Password</label>
                                <div class="ica-password-wrapper">
                                    <input type="password" id="password_confirmation" name="password_confirmation" class="ica-form-control" 
                                           placeholder="Re-enter your password" required>
                                    <button type="button" class="ica-password-toggle" onclick="togglePassword('password_confirmation', 'confirm-icon')">
                                        <i class="fas fa-eye" id="confirm-icon"></i>
                                    </button>
                                </div>
                            </div>

                            @if (get_settings('allow_instructor'))
                                <div class="ica-form-group">
                                    <label class="ica-form-label">Register As</label>
                                    <div class="d-flex gap-3">
                                        <label class="d-flex align-items-center gap-2 cursor-pointer">
                                            <input type="radio" name="role" value="student" checked>
                                            <span>Student</span>
                                        </label>
                                        <label class="d-flex align-items-center gap-2 cursor-pointer">
                                            <input type="radio" name="role" value="instructor">
                                            <span>Instructor</span>
                                        </label>
                                    </div>
                                </div>
                            @endif

                            @if(get_frontend_settings('recaptcha_status'))
                                <button type="submit" class="ica-btn-register g-recaptcha" 
                                        data-sitekey="{{ get_frontend_settings('recaptcha_sitekey') }}" 
                                        data-callback='onIcaRegisterSubmit' 
                                        data-action='submit'>
                                    <i class="fas fa-user-plus me-2"></i> Create Account
                                </button>
                            @else
                                <button type="submit" class="ica-btn-register">
                                    <i class="fas fa-user-plus me-2"></i> Create Account
                                </button>
                            @endif
                        </form>

                        <div class="ica-divider">
                            <span>OR</span>
                        </div>

                        <div class="ica-login-link">
                            Already have an account? 
                            <a href="{{ route('login') }}">Login Here</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('js')
<script>
    "use strict";

    function togglePassword(inputId, iconId) {
        const passwordInput = document.getElementById(inputId);
        const passwordIcon = document.getElementById(iconId);
        
        if (passwordInput.type === 'password') {
            passwordInput.type = 'text';
            passwordIcon.classList.remove('fa-eye');
            passwordIcon.classList.add('fa-eye-slash');
        } else {
            passwordInput.type = 'password';
            passwordIcon.classList.remove('fa-eye-slash');
            passwordIcon.classList.add('fa-eye');
        }
    }

    function onIcaRegisterSubmit(token) {
        document.getElementById("ica-register-form").submit();
    }
</script>
@endpush
