@if (get_frontend_settings('recaptcha_status'))
    @push('js')
        <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    @endpush
@endif

<style>
    .elegant-footer {
        background: #11273f;
        color: rgba(255,255,255,0.85);
        padding: 60px 0 0;
        font-size: 0.95rem;
    }

    .elegant-footer a {
        color: rgba(255,255,255,0.85);
        text-decoration: none;
        transition: color 0.2s;
    }

    .elegant-footer a:hover {
        color: #f2862d;
    }

    .footer-logo {
        height: 45px;
        margin-bottom: 20px;
    }

    .footer-section-title {
        color: white;
        font-size: 1.1rem;
        font-weight: 600;
        margin-bottom: 20px;
        letter-spacing: -0.2px;
    }

    .footer-links {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .footer-links li {
        margin-bottom: 12px;
    }

    .footer-links a {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        font-size: 0.9rem;
    }

    .footer-links a:hover {
        transform: translateX(3px);
        transition: transform 0.2s;
    }

    .footer-links i {
        color: #f2862d;
        font-size: 0.75rem;
    }

    .social-links-elegant {
        display: flex;
        gap: 12px;
        margin-top: 20px;
    }

    .social-link-elegant {
        width: 40px;
        height: 40px;
        border-radius: 8px;
        background: rgba(255,255,255,0.08);
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 1.1rem;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        border: 1px solid rgba(255,255,255,0.1);
    }

    .social-link-elegant:hover {
        background: #f2862d;
        border-color: #f2862d;
        color: white;
        transform: translateY(-2px);
    }

    .contact-item-elegant {
        display: flex;
        align-items: start;
        gap: 12px;
        margin-bottom: 16px;
        padding: 12px;
        background: rgba(255,255,255,0.05);
        border-radius: 8px;
        border: 1px solid rgba(255,255,255,0.08);
    }

    .contact-icon-elegant {
        width: 36px;
        height: 36px;
        border-radius: 6px;
        background: #f2862d;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
        font-size: 0.9rem;
    }

    .newsletter-form-elegant {
        display: flex;
        gap: 10px;
        margin-top: 15px;
    }

    .newsletter-form-elegant input {
        flex: 1;
        padding: 12px 16px;
        border: 1px solid rgba(255,255,255,0.2);
        border-radius: 6px;
        background: rgba(255,255,255,0.08);
        color: white;
        font-size: 0.9rem;
        transition: all 0.2s;
    }

    .newsletter-form-elegant input:focus {
        outline: none;
        border-color: #f2862d;
        background: rgba(255,255,255,0.12);
    }

    .newsletter-form-elegant input::placeholder {
        color: rgba(255,255,255,0.5);
    }

    .newsletter-form-elegant button {
        padding: 12px 24px;
        border: none;
        border-radius: 6px;
        background: linear-gradient(135deg, #f2862d, #ff9f4d);
        color: white;
        font-weight: 600;
        font-size: 0.9rem;
        cursor: pointer;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        white-space: nowrap;
    }

    .newsletter-form-elegant button:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(242, 134, 45, 0.3);
    }

    .footer-bottom {
        background: rgba(0,0,0,0.2);
        padding: 25px 0;
        margin-top: 50px;
        border-top: 1px solid rgba(255,255,255,0.1);
    }

    .footer-policy-links {
        list-style: none;
        padding: 0;
        margin: 0;
        display: flex;
        flex-wrap: wrap;
        gap: 20px;
        font-size: 0.85rem;
    }

    .footer-policy-links a {
        color: rgba(255,255,255,0.7);
    }

    .footer-policy-links a:hover {
        color: #f2862d;
    }

    .footer-copyright {
        color: rgba(255,255,255,0.6);
        font-size: 0.85rem;
        text-align: right;
    }

    @media (max-width: 768px) {
        .footer-policy-links {
            justify-content: center;
        }
        .footer-copyright {
            text-align: center;
            margin-top: 15px;
        }
    }
</style>

<footer class="elegant-footer">
    <div class="container">
        <div class="row g-4">
            <!-- About Section -->
            <div class="col-lg-4 col-md-6">
                <img src="{{ get_image(get_frontend_settings('light_logo')) }}" alt="Industry Connect Academy" class="footer-logo">
                <p style="line-height: 1.7; margin-bottom: 20px;">
                    Industry Connect Academy (ICA) is Ghana's premier industrial training institution, offering professional face-to-face training in Project Management, NDT, HSE, and more.
                </p>
                
                <div class="social-links-elegant">
                    <a href="{{ get_frontend_settings('facebook') }}" class="social-link-elegant" target="_blank" title="Facebook">
                        <i class="fab fa-facebook-f"></i>
                    </a>
                    <a href="{{ get_frontend_settings('twitter') }}" class="social-link-elegant" target="_blank" title="Twitter">
                        <i class="fab fa-twitter"></i>
                    </a>
                    <a href="{{ get_frontend_settings('linkedin') }}" class="social-link-elegant" target="_blank" title="LinkedIn">
                        <i class="fab fa-linkedin-in"></i>
                    </a>
                    <a href="https://www.instagram.com/industry_connect_academy/" class="social-link-elegant" target="_blank" title="Instagram">
                        <i class="fab fa-instagram"></i>
                    </a>
                </div>
            </div>

            <!-- Quick Links -->
            <div class="col-lg-2 col-md-6">
                <h4 class="footer-section-title">Quick Links</h4>
                <ul class="footer-links">
                    <li>
                        <a href="{{ route('home') }}">
                            <i class="fas fa-chevron-right"></i> Home
                        </a>
                    </li>
                    <li>
                        <a href="{{ route('home') }}#programs">
                            <i class="fas fa-chevron-right"></i> Programs
                        </a>
                    </li>
                    <li>
                        <a href="{{ route('about.us') }}">
                            <i class="fas fa-chevron-right"></i> About Us
                        </a>
                    </li>
                    <li>
                        <a href="{{ route('contact.us') }}">
                            <i class="fas fa-chevron-right"></i> Contact
                        </a>
                    </li>
                    @auth
                        <li>
                            <a href="{{ route('ica.enrollment') }}">
                                <i class="fas fa-chevron-right"></i> Enroll Now
                            </a>
                        </li>
                    @else
                        <li>
                            <a href="{{ route('register') }}">
                                <i class="fas fa-chevron-right"></i> Register
                            </a>
                        </li>
                    @endauth
                </ul>
            </div>

            <!-- Training Categories -->
            <div class="col-lg-3 col-md-6">
                <h4 class="footer-section-title">Training Programs</h4>
                <ul class="footer-links">
                    <li>
                        <a href="{{ route('home') }}#programs">
                            <i class="fas fa-chevron-right"></i> Project Management
                        </a>
                    </li>
                    <li>
                        <a href="{{ route('home') }}#programs">
                            <i class="fas fa-chevron-right"></i> Height Works
                        </a>
                    </li>
                    <li>
                        <a href="{{ route('home') }}#programs">
                            <i class="fas fa-chevron-right"></i> NDT Programs
                        </a>
                    </li>
                    <li>
                        <a href="{{ route('home') }}#programs">
                            <i class="fas fa-chevron-right"></i> Surface Coating
                        </a>
                    </li>
                    <li>
                        <a href="{{ route('home') }}#programs">
                            <i class="fas fa-chevron-right"></i> HSE Programs
                        </a>
                    </li>
                </ul>
            </div>

            <!-- Contact Info -->
            <div class="col-lg-3 col-md-6">
                <h4 class="footer-section-title">Contact Us</h4>
                
                <div class="contact-item-elegant">
                    <div class="contact-icon-elegant">
                        <i class="fas fa-map-marker-alt"></i>
                    </div>
                    <div>
                        <strong style="display: block; color: white; margin-bottom: 4px; font-size: 0.9rem;">Location</strong>
                        <span style="font-size: 0.85rem;">Accra, Ghana</span>
                    </div>
                </div>

                <div class="contact-item-elegant">
                    <div class="contact-icon-elegant">
                        <i class="fas fa-phone"></i>
                    </div>
                    <div>
                        <strong style="display: block; color: white; margin-bottom: 4px; font-size: 0.9rem;">Phone</strong>
                        <span style="font-size: 0.85rem;">+233 (0)54 627 3013</span>
                    </div>
                </div>

                <div class="contact-item-elegant">
                    <div class="contact-icon-elegant">
                        <i class="fas fa-envelope"></i>
                    </div>
                    <div>
                        <strong style="display: block; color: white; margin-bottom: 4px; font-size: 0.9rem;">Email</strong>
                        <span style="font-size: 0.85rem;">{{ get_settings('system_email') }}</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Newsletter Section -->
        <div class="row mt-4">
            <div class="col-lg-6 mx-auto text-center">
                <h4 class="footer-section-title">Stay Updated</h4>
                <p style="font-size: 0.9rem; margin-bottom: 15px;">Subscribe to our newsletter for latest training programs and updates</p>
                <form action="{{ route('newsletter.store') }}" method="post" class="newsletter-form-elegant" id="newsletter-form-elegant">
                    @csrf
                    <input type="email" name="email" placeholder="Enter your email address" required>
                    @if(get_frontend_settings('recaptcha_status'))
                        <button type="submit" class="g-recaptcha" data-sitekey="{{ get_frontend_settings('recaptcha_sitekey') }}" data-callback='onNewsletterSubmitElegant' data-action='submit'>
                            Subscribe
                        </button>
                    @else
                        <button type="submit">Subscribe</button>
                    @endif
                </form>
            </div>
        </div>
    </div>

    <!-- Footer Bottom -->
    <div class="footer-bottom">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8 col-md-12 mb-3 mb-lg-0">
                    <ul class="footer-policy-links">
                        <li><a href="{{ route('about.us') }}">About Us</a></li>
                        <li><a href="{{ route('privacy.policy') }}">Privacy Policy</a></li>
                        <li><a href="{{ route('terms.condition') }}">Terms & Conditions</a></li>
                        <li><a href="{{ route('refund.policy') }}">Refund Policy</a></li>
                        <li><a href="{{ route('cookie.policy') }}">Cookie Policy</a></li>
                        <li><a href="{{ route('faq') }}">FAQ</a></li>
                    </ul>
                </div>
                <div class="col-lg-4 col-md-12">
                    <div class="footer-copyright">
                        <i class="fas fa-copyright me-1"></i> {{ date('Y') }} Industry Connect Academy. All Rights Reserved.
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>

@push('js')
<script>
    "use strict";
    function onNewsletterSubmitElegant(token) {
        document.getElementById("newsletter-form-elegant").submit();
    }
</script>
@endpush
