@if (get_frontend_settings('recaptcha_status'))
    @push('js')
        <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    @endpush
@endif

<style>
    .ica-footer {
        background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%);
        color: white;
        padding: 60px 0 0;
        position: relative;
    }

    .ica-footer::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(to right, #CE1126, #FCD116, #006B3F);
    }

    .ica-footer-logo {
        height: 50px;
        margin-bottom: 20px;
    }

    .ica-footer h4 {
        color: #FCD116;
        font-weight: 700;
        margin-bottom: 20px;
        font-size: 1.2rem;
    }

    .ica-footer p {
        color: #cccccc;
        line-height: 1.8;
    }

    .ica-footer-links {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .ica-footer-links li {
        margin-bottom: 12px;
    }

    .ica-footer-links a {
        color: #cccccc;
        text-decoration: none;
        transition: all 0.3s;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .ica-footer-links a:hover {
        color: #FCD116;
        transform: translateX(5px);
    }

    .ica-footer-links a i {
        color: #006B3F;
    }

    .ica-social-links {
        display: flex;
        gap: 15px;
        margin-top: 20px;
    }

    .ica-social-link {
        width: 45px;
        height: 45px;
        border-radius: 50%;
        background: rgba(252, 209, 22, 0.1);
        display: flex;
        align-items: center;
        justify-content: center;
        color: #FCD116;
        font-size: 1.2rem;
        transition: all 0.3s;
        text-decoration: none;
    }

    .ica-social-link:hover {
        background: linear-gradient(135deg, #006B3F, #FCD116);
        color: white;
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(252, 209, 22, 0.3);
    }

    .ica-contact-item {
        display: flex;
        align-items-start;
        gap: 15px;
        margin-bottom: 20px;
        padding: 15px;
        background: rgba(255, 255, 255, 0.05);
        border-radius: 10px;
        transition: all 0.3s;
    }

    .ica-contact-item:hover {
        background: rgba(0, 107, 63, 0.2);
        transform: translateX(5px);
    }

    .ica-contact-icon {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background: linear-gradient(135deg, #006B3F, #FCD116);
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
    }

    .ica-newsletter-form {
        display: flex;
        gap: 10px;
        margin-top: 15px;
    }

    .ica-newsletter-form input {
        flex: 1;
        padding: 12px 20px;
        border: 2px solid rgba(252, 209, 22, 0.3);
        border-radius: 50px;
        background: rgba(255, 255, 255, 0.1);
        color: white;
        transition: all 0.3s;
    }

    .ica-newsletter-form input:focus {
        outline: none;
        border-color: #FCD116;
        background: rgba(255, 255, 255, 0.15);
    }

    .ica-newsletter-form input::placeholder {
        color: #999;
    }

    .ica-newsletter-form button {
        padding: 12px 30px;
        border: none;
        border-radius: 50px;
        background: linear-gradient(135deg, #006B3F, #FCD116);
        color: white;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s;
        white-space: nowrap;
    }

    .ica-newsletter-form button:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(252, 209, 22, 0.4);
    }

    .ica-footer-bottom {
        background: rgba(0, 0, 0, 0.3);
        padding: 25px 0;
        margin-top: 50px;
        border-top: 1px solid rgba(252, 209, 22, 0.2);
    }

    .ica-footer-policy {
        list-style: none;
        padding: 0;
        margin: 0;
        display: flex;
        flex-wrap: wrap;
        gap: 20px;
    }

    .ica-footer-policy a {
        color: #cccccc;
        text-decoration: none;
        transition: all 0.3s;
        font-size: 0.9rem;
    }

    .ica-footer-policy a:hover {
        color: #FCD116;
    }

    .ica-copyright {
        color: #999;
        font-size: 0.9rem;
        text-align: right;
    }

    @media (max-width: 768px) {
        .ica-footer-policy {
            justify-content: center;
        }
        .ica-copyright {
            text-align: center;
            margin-top: 15px;
        }
    }
</style>

<footer class="ica-footer">
    <div class="container">
        <div class="row g-4">
            <!-- About Section -->
            <div class="col-lg-4 col-md-6">
                <img src="{{ get_image(get_frontend_settings('light_logo')) }}" alt="Industry Connect Academy" class="ica-footer-logo">
                <p>Industry Connect Academy (ICA) is Ghana's premier industrial training institution, offering professional face-to-face training in Project Management, NDT, HSE, Height Works, Surface Coating, and more.</p>
                
                <div class="ica-social-links">
                    <a href="{{ get_frontend_settings('facebook') }}" class="ica-social-link" target="_blank">
                        <i class="fab fa-facebook-f"></i>
                    </a>
                    <a href="{{ get_frontend_settings('twitter') }}" class="ica-social-link" target="_blank">
                        <i class="fab fa-twitter"></i>
                    </a>
                    <a href="{{ get_frontend_settings('linkedin') }}" class="ica-social-link" target="_blank">
                        <i class="fab fa-linkedin-in"></i>
                    </a>
                    <a href="#" class="ica-social-link" target="_blank">
                        <i class="fab fa-instagram"></i>
                    </a>
                </div>
            </div>

            <!-- Quick Links -->
            <div class="col-lg-2 col-md-6">
                <h4>Quick Links</h4>
                <ul class="ica-footer-links">
                    <li>
                        <a href="{{ route('home') }}">
                            <i class="fas fa-chevron-right"></i> Home
                        </a>
                    </li>
                    <li>
                        <a href="{{ route('home') }}#programs">
                            <i class="fas fa-chevron-right"></i> Programs
                        </a>
                    </li>
                    <li>
                        <a href="{{ route('about.us') }}">
                            <i class="fas fa-chevron-right"></i> About Us
                        </a>
                    </li>
                    <li>
                        <a href="{{ route('contact.us') }}">
                            <i class="fas fa-chevron-right"></i> Contact
                        </a>
                    </li>
                    @auth
                        <li>
                            <a href="{{ route('ica.enrollment') }}">
                                <i class="fas fa-chevron-right"></i> Enroll Now
                            </a>
                        </li>
                    @else
                        <li>
                            <a href="{{ route('register') }}">
                                <i class="fas fa-chevron-right"></i> Register
                            </a>
                        </li>
                    @endauth
                </ul>
            </div>

            <!-- Training Categories -->
            <div class="col-lg-3 col-md-6">
                <h4>Training Categories</h4>
                <ul class="ica-footer-links">
                    <li>
                        <a href="{{ route('home') }}#programs">
                            <i class="fas fa-chevron-right"></i> Project Management
                        </a>
                    </li>
                    <li>
                        <a href="{{ route('home') }}#programs">
                            <i class="fas fa-chevron-right"></i> Height Works
                        </a>
                    </li>
                    <li>
                        <a href="{{ route('home') }}#programs">
                            <i class="fas fa-chevron-right"></i> NDT (ASNT Level II)
                        </a>
                    </li>
                    <li>
                        <a href="{{ route('home') }}#programs">
                            <i class="fas fa-chevron-right"></i> Surface Coating
                        </a>
                    </li>
                    <li>
                        <a href="{{ route('home') }}#programs">
                            <i class="fas fa-chevron-right"></i> HSE Programs
                        </a>
                    </li>
                </ul>
            </div>

            <!-- Contact Info -->
            <div class="col-lg-3 col-md-6">
                <h4>Contact Us</h4>
                
                <div class="ica-contact-item">
                    <div class="ica-contact-icon">
                        <i class="fas fa-map-marker-alt"></i>
                    </div>
                    <div>
                        <strong>Location</strong><br>
                        <small>Accra, Ghana</small>
                    </div>
                </div>

                <div class="ica-contact-item">
                    <div class="ica-contact-icon">
                        <i class="fas fa-envelope"></i>
                    </div>
                    <div>
                        <strong>Email</strong><br>
                        <small>{{ get_settings('system_email') }}</small>
                    </div>
                </div>

                <div class="ica-contact-item">
                    <div class="ica-contact-icon">
                        <i class="fas fa-phone"></i>
                    </div>
                    <div>
                        <strong>Phone</strong><br>
                        <small>{{ get_settings('phone') }}</small>
                    </div>
                </div>
            </div>
        </div>

        <!-- Newsletter Section -->
        <div class="row mt-4">
            <div class="col-lg-6 mx-auto text-center">
                <h4><i class="fas fa-envelope-open-text me-2"></i> Subscribe to Our Newsletter</h4>
                <p>Stay updated with our latest training programs and industry news</p>
                <form action="{{ route('newsletter.store') }}" method="post" class="ica-newsletter-form" id="ica-newsletter-form">
                    @csrf
                    <input type="email" name="email" placeholder="Enter your email address" required>
                    @if(get_frontend_settings('recaptcha_status'))
                        <button type="submit" class="g-recaptcha" data-sitekey="{{ get_frontend_settings('recaptcha_sitekey') }}" data-callback='onIcaNewsletterSubmit' data-action='submit'>
                            Subscribe
                        </button>
                    @else
                        <button type="submit">Subscribe</button>
                    @endif
                </form>
            </div>
        </div>
    </div>

    <!-- Footer Bottom -->
    <div class="ica-footer-bottom">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8 col-md-12 mb-3 mb-lg-0">
                    <ul class="ica-footer-policy">
                        <li><a href="{{ route('about.us') }}">About Us</a></li>
                        <li><a href="{{ route('privacy.policy') }}">Privacy Policy</a></li>
                        <li><a href="{{ route('terms.condition') }}">Terms & Conditions</a></li>
                        <li><a href="{{ route('refund.policy') }}">Refund Policy</a></li>
                        <li><a href="{{ route('cookie.policy') }}">Cookie Policy</a></li>
                        <li><a href="{{ route('faq') }}">FAQ</a></li>
                    </ul>
                </div>
                <div class="col-lg-4 col-md-12">
                    <div class="ica-copyright">
                        <i class="fas fa-copyright me-1"></i> {{ date('Y') }} Industry Connect Academy. All Rights Reserved.
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>

@push('js')
<script>
    "use strict";
    function onIcaNewsletterSubmit(token) {
        document.getElementById("ica-newsletter-form").submit();
    }
</script>
@endpush
