@php
    $current_route = Route::currentRouteName();
@endphp

<style>
    .ica-header {
        background: white;
        box-shadow: 0 2px 20px rgba(0,0,0,0.08);
        position: sticky;
        top: 0;
        z-index: 1000;
        border-bottom: 3px solid transparent;
        border-image: linear-gradient(to right, #CE1126, #FCD116, #006B3F) 1;
    }

    .ica-logo {
        height: 60px;
        object-fit: contain;
    }

    .ica-nav {
        display: flex;
        align-items: center;
        gap: 30px;
    }

    .ica-nav-link {
        color: #1a1a1a;
        font-weight: 600;
        font-size: 1rem;
        text-decoration: none;
        padding: 10px 0;
        position: relative;
        transition: all 0.3s;
    }

    .ica-nav-link:hover,
    .ica-nav-link.active {
        color: #006B3F;
    }

    .ica-nav-link::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        width: 0;
        height: 3px;
        background: linear-gradient(to right, #006B3F, #FCD116);
        transition: width 0.3s;
    }

    .ica-nav-link:hover::after,
    .ica-nav-link.active::after {
        width: 100%;
    }

    .ica-btn-primary {
        background: linear-gradient(135deg, #006B3F, #00a651);
        color: white;
        padding: 10px 25px;
        border-radius: 50px;
        font-weight: 600;
        text-decoration: none;
        transition: all 0.3s;
        box-shadow: 0 4px 15px rgba(0,107,63,0.3);
    }

    .ica-btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(0,107,63,0.4);
        color: white;
    }

    .ica-btn-secondary {
        background: white;
        color: #006B3F;
        border: 2px solid #006B3F;
        padding: 8px 25px;
        border-radius: 50px;
        font-weight: 600;
        text-decoration: none;
        transition: all 0.3s;
    }

    .ica-btn-secondary:hover {
        background: #006B3F;
        color: white;
    }

    .ica-user-menu {
        position: relative;
    }

    .ica-user-avatar {
        width: 45px;
        height: 45px;
        border-radius: 50%;
        border: 3px solid #006B3F;
        cursor: pointer;
        transition: all 0.3s;
    }

    .ica-user-avatar:hover {
        transform: scale(1.05);
        box-shadow: 0 5px 15px rgba(0,107,63,0.3);
    }

    .mobile-menu-toggle {
        display: none;
        background: linear-gradient(135deg, #006B3F, #FCD116);
        color: white;
        border: none;
        padding: 10px 15px;
        border-radius: 8px;
        font-size: 1.2rem;
        cursor: pointer;
    }

    @media (max-width: 991px) {
        .ica-nav {
            display: none;
        }
        .mobile-menu-toggle {
            display: block;
        }
    }
</style>

<header class="ica-header">
    <div class="container">
        <div class="row align-items-center py-3">
            <div class="col-auto">
                <a href="{{ route('home') }}">
                    <img src="{{ get_image(get_frontend_settings('dark_logo')) }}" alt="Industry Connect Academy" class="ica-logo">
                </a>
            </div>
            
            <div class="col d-none d-lg-block">
                <nav class="ica-nav">
                    <a href="{{ route('home') }}" class="ica-nav-link @if($current_route == 'home') active @endif">
                        <i class="fas fa-home me-1"></i> Home
                    </a>
                    <a href="{{ route('home') }}#programs" class="ica-nav-link" onclick="event.preventDefault(); document.getElementById('programs').scrollIntoView({behavior: 'smooth'});">
                        <i class="fas fa-graduation-cap me-1"></i> Programs
                    </a>
                    <a href="{{ route('about.us') }}" class="ica-nav-link @if($current_route == 'about.us') active @endif">
                        <i class="fas fa-info-circle me-1"></i> About Us
                    </a>
                    <a href="{{ route('contact.us') }}" class="ica-nav-link @if($current_route == 'contact.us') active @endif">
                        <i class="fas fa-envelope me-1"></i> Contact
                    </a>
                </nav>
            </div>

            <div class="col-auto ms-auto">
                <div class="d-flex align-items-center gap-3">
                    @auth
                        <a href="{{ route('ica.enrollment') }}" class="ica-btn-primary d-none d-md-inline-block">
                            <i class="fas fa-file-alt me-1"></i> Enroll Now
                        </a>
                        
                        <div class="ica-user-menu">
                            <button class="us-btn dropdown-toggle p-0 border-0 bg-transparent" type="button" data-bs-toggle="dropdown">
                                <img src="{{ get_image(auth()->user()->photo) }}" alt="{{ auth()->user()->name }}" class="ica-user-avatar">
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end">
                                <li class="px-3 py-2 border-bottom">
                                    <div class="fw-bold">{{ auth()->user()->name }}</div>
                                    <small class="text-muted">{{ auth()->user()->email }}</small>
                                </li>
                                
                                @if(in_array(auth()->user()->role, ['admin', 'instructor']))
                                    <li>
                                        <a class="dropdown-item" href="{{ route(auth()->user()->role . '.dashboard') }}">
                                            <i class="fas fa-tachometer-alt me-2"></i> Dashboard
                                        </a>
                                    </li>
                                    <li><hr class="dropdown-divider"></li>
                                @endif
                                
                                @if(auth()->user()->role == 'admin')
                                    <li>
                                        <a class="dropdown-item" href="{{ route('admin.ica.enrollments') }}">
                                            <i class="fas fa-users me-2"></i> ICA Enrollments
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="{{ route('admin.ica.programs') }}">
                                            <i class="fas fa-book me-2"></i> ICA Programs
                                        </a>
                                    </li>
                                    <li><hr class="dropdown-divider"></li>
                                @endif
                                
                                @if(auth()->user()->role != 'admin')
                                    <li>
                                        <a class="dropdown-item" href="{{ route('my.profile') }}">
                                            <i class="fas fa-user me-2"></i> My Profile
                                        </a>
                                    </li>
                                @endif
                                
                                <li>
                                    <a class="dropdown-item text-danger" href="{{ route('logout') }}">
                                        <i class="fas fa-sign-out-alt me-2"></i> Logout
                                    </a>
                                </li>
                            </ul>
                        </div>
                    @else
                        <a href="{{ route('register') }}" class="ica-btn-primary d-none d-md-inline-block">
                            <i class="fas fa-user-plus me-1"></i> Register
                        </a>
                        <a href="{{ route('login') }}" class="ica-btn-secondary d-none d-sm-inline-block">
                            <i class="fas fa-sign-in-alt me-1"></i> Login
                        </a>
                    @endauth
                    
                    <button class="mobile-menu-toggle" data-bs-toggle="offcanvas" data-bs-target="#icaMobileMenu">
                        <i class="fas fa-bars"></i>
                    </button>
                </div>
            </div>
        </div>
    </div>
</header>

<!-- Mobile Menu -->
<div class="offcanvas offcanvas-end" tabindex="-1" id="icaMobileMenu">
    <div class="offcanvas-header" style="background: linear-gradient(135deg, #006B3F, #FCD116); color: white;">
        <h5 class="offcanvas-title fw-bold">
            <i class="fas fa-graduation-cap me-2"></i> ICA Menu
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
    </div>
    <div class="offcanvas-body">
        @auth
            <div class="d-flex align-items-center gap-3 p-3 mb-3" style="background: #f8f9fa; border-radius: 12px;">
                <img src="{{ get_image(auth()->user()->photo) }}" alt="{{ auth()->user()->name }}" style="width: 50px; height: 50px; border-radius: 50%; border: 3px solid #006B3F;">
                <div>
                    <div class="fw-bold">{{ auth()->user()->name }}</div>
                    <small class="text-muted">{{ auth()->user()->email }}</small>
                </div>
            </div>
        @endauth
        
        <nav class="d-flex flex-column gap-2">
            <a href="{{ route('home') }}" class="btn btn-outline-success text-start" data-bs-dismiss="offcanvas">
                <i class="fas fa-home me-2"></i> Home
            </a>
            <a href="{{ route('home') }}#programs" class="btn btn-outline-success text-start" data-bs-dismiss="offcanvas">
                <i class="fas fa-graduation-cap me-2"></i> Programs
            </a>
            <a href="{{ route('about.us') }}" class="btn btn-outline-success text-start" data-bs-dismiss="offcanvas">
                <i class="fas fa-info-circle me-2"></i> About Us
            </a>
            <a href="{{ route('contact.us') }}" class="btn btn-outline-success text-start" data-bs-dismiss="offcanvas">
                <i class="fas fa-envelope me-2"></i> Contact
            </a>
            
            <hr>
            
            @auth
                <a href="{{ route('ica.enrollment') }}" class="btn btn-success text-start" data-bs-dismiss="offcanvas">
                    <i class="fas fa-file-alt me-2"></i> Enroll Now
                </a>
                
                @if(auth()->user()->role == 'admin')
                    <a href="{{ route('admin.ica.enrollments') }}" class="btn btn-outline-primary text-start" data-bs-dismiss="offcanvas">
                        <i class="fas fa-users me-2"></i> ICA Enrollments
                    </a>
                    <a href="{{ route('admin.ica.programs') }}" class="btn btn-outline-primary text-start" data-bs-dismiss="offcanvas">
                        <i class="fas fa-book me-2"></i> ICA Programs
                    </a>
                @endif
                
                <a href="{{ route('logout') }}" class="btn btn-outline-danger text-start">
                    <i class="fas fa-sign-out-alt me-2"></i> Logout
                </a>
            @else
                <a href="{{ route('register') }}" class="btn btn-success text-start" data-bs-dismiss="offcanvas">
                    <i class="fas fa-user-plus me-2"></i> Register
                </a>
                <a href="{{ route('login') }}" class="btn btn-outline-success text-start" data-bs-dismiss="offcanvas">
                    <i class="fas fa-sign-in-alt me-2"></i> Login
                </a>
            @endauth
        </nav>
    </div>
</div>
