@extends('layouts.default')
@push('title', 'Industry Connect Academy - Professional Industrial Training in Ghana')
@push('meta')@endpush
@push('css')
<style>
    :root {
        --ica-navy: #11273f;
        --ica-navy-light: #1a3a5f;
        --ica-orange: #f2862d;
        --ica-orange-light: #ff9f4d;
        --ica-gray: #6c757d;
        --ica-gray-light: #8b95a1;
        --ica-bg: #fafbfc;
    }
    
    body {
        background-color: #ffffff;
        font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', 'Roboto', sans-serif;
        color: #2d3748;
        line-height: 1.65;
        letter-spacing: -0.01em;
    }

    /* Hero Section - Elegant */
    .hero-section {
        background: linear-gradient(165deg, #0a1829 0%, #11273f 45%, #1a3a5f 100%);
        padding: 100px 0 110px;
        position: relative;
        overflow: hidden;
    }

    .hero-section::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: radial-gradient(circle at 20% 50%, rgba(242, 134, 45, 0.08) 0%, transparent 50%);
        pointer-events: none;
    }

    .hero-section::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        height: 1px;
        background: linear-gradient(90deg, transparent, #f2862d 50%, transparent);
    }

    .hero-section h1 {
        color: white;
        font-size: 3.5rem;
        font-weight: 700;
        margin-bottom: 1.5rem;
        letter-spacing: -1.2px;
        line-height: 1.12;
        text-shadow: 0 2px 20px rgba(0,0,0,0.15);
    }

    .hero-section .lead {
        color: #ffa366;
        font-size: 1.5rem;
        font-weight: 600;
        margin-bottom: 1.5rem;
        letter-spacing: -0.4px;
        line-height: 1.4;
    }

    .hero-section p {
        color: rgba(255,255,255,0.88);
        font-size: 1.12rem;
        line-height: 1.8;
        max-width: 85%;
        font-weight: 400;
    }

    /* Buttons - Elegant */
    .btn-primary-ica {
        background: linear-gradient(135deg, #f2862d 0%, #ff9f4d 100%);
        color: white;
        border: none;
        padding: 16px 40px;
        border-radius: 10px;
        font-weight: 600;
        font-size: 1.02rem;
        transition: all 0.35s cubic-bezier(0.4, 0, 0.2, 1);
        text-decoration: none;
        display: inline-block;
        box-shadow: 0 6px 20px rgba(242, 134, 45, 0.3);
        letter-spacing: 0.4px;
        position: relative;
        overflow: hidden;
    }

    .btn-primary-ica::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
        transition: left 0.5s;
    }

    .btn-primary-ica:hover::before {
        left: 100%;
    }

    .btn-primary-ica:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 28px rgba(242, 134, 45, 0.4);
        color: white;
    }

    .btn-outline-ica {
        background: rgba(255, 255, 255, 0.1);
        color: white;
        border: 2px solid rgba(255, 255, 255, 0.35);
        padding: 14px 40px;
        border-radius: 10px;
        font-weight: 600;
        font-size: 1.02rem;
        transition: all 0.35s cubic-bezier(0.4, 0, 0.2, 1);
        text-decoration: none;
        display: inline-block;
        backdrop-filter: blur(12px);
        letter-spacing: 0.4px;
    }

    .btn-outline-ica:hover {
        background: rgba(255, 255, 255, 0.2);
        border-color: rgba(255, 255, 255, 0.6);
        color: white;
        transform: translateY(-3px);
        box-shadow: 0 6px 20px rgba(255, 255, 255, 0.15);
    }

    /* Stats - Elegant Design */
    .stats-section {
        background: linear-gradient(180deg, #f8f9fb 0%, #ffffff 100%);
        padding: 70px 0;
        border-bottom: 1px solid #e8eaed;
        position: relative;
    }

    .stats-section::before {
        content: '';
        position: absolute;
        top: 0;
        left: 50%;
        transform: translateX(-50%);
        width: 60%;
        height: 1px;
        background: linear-gradient(90deg, transparent, #f2862d, transparent);
    }

    .stat-box {
        text-align: center;
        padding: 25px 20px;
        position: relative;
    }

    .stat-box::after {
        content: '';
        position: absolute;
        right: 0;
        top: 50%;
        transform: translateY(-50%);
        width: 1px;
        height: 40px;
        background: linear-gradient(180deg, transparent, #e8eaed, transparent);
    }

    .stat-box:last-child::after {
        display: none;
    }

    .stat-number {
        font-size: 3rem;
        font-weight: 700;
        background: linear-gradient(135deg, #11273f 0%, #1a3a5f 100%);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
        margin-bottom: 0.6rem;
        letter-spacing: -1.2px;
        line-height: 1;
    }

    .stat-label {
        color: #6c757d;
        font-size: 0.92rem;
        font-weight: 500;
        letter-spacing: 0.3px;
    }

    /* Features - Elegant Cards */
    .features-section {
        padding: 90px 0;
        background: white;
        position: relative;
    }

    .section-header {
        text-align: center;
        margin-bottom: 65px;
    }

    .section-header h2 {
        font-size: 2.8rem;
        font-weight: 700;
        color: #11273f;
        margin-bottom: 1rem;
        letter-spacing: -1px;
        position: relative;
        display: inline-block;
    }

    .section-header h2::after {
        content: '';
        position: absolute;
        bottom: -12px;
        left: 50%;
        transform: translateX(-50%);
        width: 60px;
        height: 3px;
        background: linear-gradient(90deg, #f2862d, #ff9f4d);
        border-radius: 2px;
    }

    .section-header p {
        color: #6c757d;
        font-size: 1.18rem;
        font-weight: 400;
        max-width: 650px;
        margin: 0 auto;
        line-height: 1.7;
    }

    .feature-card {
        background: #fafbfc;
        border: 1px solid #e8eaed;
        border-radius: 14px;
        padding: 40px 32px;
        height: 100%;
        transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        position: relative;
        overflow: hidden;
    }

    .feature-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(90deg, #f2862d, #ff9f4d);
        transform: scaleX(0);
        transform-origin: left;
        transition: transform 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .feature-card:hover {
        background: white;
        border-color: rgba(242, 134, 45, 0.3);
        box-shadow: 0 12px 32px rgba(17, 39, 63, 0.1);
        transform: translateY(-6px);
    }

    .feature-card:hover::before {
        transform: scaleX(1);
    }

    .feature-card .icon {
        font-size: 3rem;
        background: linear-gradient(135deg, #f2862d, #ff9f4d);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
        margin-bottom: 1.4rem;
        display: inline-block;
        transition: transform 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .feature-card:hover .icon {
        transform: scale(1.1);
    }

    .feature-card h5 {
        font-size: 1.2rem;
        font-weight: 600;
        color: #11273f;
        margin-bottom: 1rem;
        letter-spacing: -0.3px;
        line-height: 1.4;
    }

    .feature-card p {
        color: #6c757d;
        font-size: 0.95rem;
        line-height: 1.65;
        margin: 0;
    }

    /* Programs Section - Elegant */
    .programs-section {
        padding: 90px 0;
        background: linear-gradient(180deg, #f8f9fb 0%, #ffffff 100%);
    }

    .category-header {
        background: white;
        border: 1px solid #e8eaed;
        border-radius: 14px;
        padding: 32px 35px;
        margin-bottom: 35px;
        box-shadow: 0 2px 12px rgba(0,0,0,0.05);
        transition: all 0.3s ease;
    }

    .category-header:hover {
        box-shadow: 0 4px 16px rgba(0,0,0,0.08);
    }

    .category-title {
        font-size: 1.65rem;
        font-weight: 700;
        color: #11273f;
        margin-bottom: 0.6rem;
        letter-spacing: -0.6px;
    }

    .category-count {
        color: #6c757d;
        font-size: 0.95rem;
        font-weight: 500;
    }

    .program-card {
        background: white;
        border: 1px solid #e8eaed;
        border-radius: 14px;
        overflow: hidden;
        height: 100%;
        transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        box-shadow: 0 2px 12px rgba(0,0,0,0.05);
    }

    .program-card:hover {
        border-color: rgba(242, 134, 45, 0.4);
        transform: translateY(-8px);
        box-shadow: 0 16px 40px rgba(17, 39, 63, 0.14);
    }

    .program-image {
        height: 220px;
        background: linear-gradient(135deg, #0d1f35 0%, #11273f 50%, #1a3a5f 100%);
        position: relative;
        overflow: hidden;
    }

    .program-image img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .program-card:hover .program-image img {
        transform: scale(1.08);
    }

    .program-image .placeholder {
        display: flex;
        align-items: center;
        justify-content: center;
        height: 100%;
        color: rgba(255,255,255,0.2);
        font-size: 3.5rem;
    }

    .program-price {
        position: absolute;
        top: 16px;
        right: 16px;
        background: rgba(17, 39, 63, 0.95);
        color: white;
        padding: 10px 18px;
        border-radius: 8px;
        font-weight: 600;
        font-size: 0.98rem;
        backdrop-filter: blur(12px);
        letter-spacing: 0.4px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    }

    .program-duration {
        position: absolute;
        bottom: 16px;
        left: 16px;
        background: rgba(255, 255, 255, 0.98);
        color: #11273f;
        padding: 8px 16px;
        border-radius: 8px;
        font-size: 0.88rem;
        font-weight: 600;
        backdrop-filter: blur(12px);
        letter-spacing: 0.3px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    }

    .program-content {
        padding: 28px;
    }

    .program-title {
        font-size: 1.12rem;
        font-weight: 600;
        color: #11273f;
        margin-bottom: 1rem;
        letter-spacing: -0.2px;
        line-height: 1.4;
        line-height: 1.45;
        min-height: 50px;
        letter-spacing: -0.2px;
    }

    .program-location {
        color: #6c757d;
        font-size: 0.9rem;
        margin-bottom: 0.85rem;
        font-weight: 500;
    }

    .program-location i {
        color: #f2862d;
        margin-right: 2px;
    }

    .program-description {
        color: #8b95a1;
        font-size: 0.9rem;
        line-height: 1.6;
        margin: 0;
    }

    /* Enrollment Steps - Elegant */
    .steps-section {
        padding: 90px 0;
        background: white;
        position: relative;
    }

    .step-item {
        text-align: center;
        padding: 30px 20px;
        position: relative;
        transition: all 0.3s ease;
    }

    .step-item:hover {
        transform: translateY(-4px);
    }

    .step-number {
        width: 75px;
        height: 75px;
        background: linear-gradient(135deg, #11273f 0%, #1a3a5f 100%);
        color: white;
        border-radius: 50%;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        font-size: 1.7rem;
        font-weight: 700;
        margin-bottom: 1.4rem;
        box-shadow: 0 6px 20px rgba(17, 39, 63, 0.25);
        position: relative;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .step-item:hover .step-number {
        transform: scale(1.05);
        box-shadow: 0 8px 24px rgba(17, 39, 63, 0.3);
    }

    .step-number::after {
        content: '';
        position: absolute;
        inset: -5px;
        border-radius: 50%;
        border: 2.5px solid #f2862d;
        opacity: 0;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .step-item:hover .step-number::after {
        opacity: 1;
    }

    .step-item h5 {
        font-size: 1.2rem;
        font-weight: 600;
        color: #11273f;
        margin-bottom: 0.75rem;
        letter-spacing: -0.3px;
    }

    .step-item p {
        color: #6c757d;
        font-size: 0.98rem;
        line-height: 1.65;
        margin: 0;
    }

    /* CTA Section - Elegant */
    .cta-section {
        background: linear-gradient(165deg, #0a1829 0%, #11273f 45%, #1a3a5f 100%);
        padding: 90px 0;
        text-align: center;
        position: relative;
        overflow: hidden;
    }

    .cta-section::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 1px;
        background: linear-gradient(90deg, transparent, #f2862d 50%, transparent);
    }

    .cta-section::after {
        content: '';
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        width: 600px;
        height: 600px;
        background: radial-gradient(circle, rgba(242, 134, 45, 0.08) 0%, transparent 70%);
        pointer-events: none;
    }

    .cta-section h2 {
        color: white;
        font-size: 2.6rem;
        font-weight: 700;
        margin-bottom: 1.4rem;
        letter-spacing: -1px;
        position: relative;
        z-index: 1;
        text-shadow: 0 2px 20px rgba(0,0,0,0.15);
    }

    .cta-section p {
        color: rgba(255,255,255,0.88);
        font-size: 1.2rem;
        margin-bottom: 2.8rem;
        position: relative;
        z-index: 1;
        line-height: 1.6;
    }

    /* Contact Section - Elegant */
    .contact-section {
        padding: 90px 0;
        background: linear-gradient(180deg, #f8f9fb 0%, #ffffff 100%);
    }

    .contact-info-item {
        display: flex;
        align-items: start;
        gap: 20px;
        margin-bottom: 0;
        padding: 24px;
        background: white;
        border-radius: 12px;
        border: 1px solid #e8eaed;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        height: 100%;
    }

    .contact-info-item:hover {
        border-color: rgba(242, 134, 45, 0.3);
        box-shadow: 0 8px 20px rgba(242, 134, 45, 0.12);
        transform: translateY(-4px);
    }

    .contact-icon {
        width: 52px;
        height: 52px;
        background: linear-gradient(135deg, #f2862d, #ff9f4d);
        color: white;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
        box-shadow: 0 4px 14px rgba(242, 134, 45, 0.3);
        font-size: 1.1rem;
        transition: transform 0.3s ease;
    }

    .contact-info-item:hover .contact-icon {
        transform: scale(1.05);
    }

    .contact-info-item strong {
        color: #11273f;
        display: block;
        margin-bottom: 0.4rem;
        font-weight: 600;
        font-size: 1rem;
        letter-spacing: -0.1px;
    }

    .contact-info-item span {
        color: #6c757d;
        font-size: 0.96rem;
        line-height: 1.5;
    }

    .help-box {
        background: white;
        border: 1px solid #e8eaed;
        border-radius: 14px;
        padding: 45px;
        box-shadow: 0 6px 20px rgba(0,0,0,0.07);
        transition: all 0.3s ease;
    }

    .help-box:hover {
        box-shadow: 0 8px 28px rgba(0,0,0,0.1);
    }

    .help-box h4 {
        color: #11273f;
        font-weight: 700;
        margin-bottom: 1.3rem;
        font-size: 1.5rem;
        letter-spacing: -0.4px;
    }

    .help-box p {
        color: #6c757d;
        margin-bottom: 2rem;
        line-height: 1.7;
        font-size: 1.02rem;
    }

    @media (max-width: 991px) {
        .hero-section {
            padding: 70px 0 80px;
        }
        .hero-section h1 {
            font-size: 2.5rem;
        }
        .hero-section .lead {
            font-size: 1.3rem;
        }
        .section-header h2 {
            font-size: 2.2rem;
        }
        .features-section, .programs-section, .steps-section, .contact-section {
            padding: 70px 0;
        }
    }

    @media (max-width: 767px) {
        .hero-section h1 {
            font-size: 1.8rem;
        }
        .hero-section .lead {
            font-size: 1.1rem;
        }
    }
</style>
@endpush

@section('content')

<!-- Hero Section -->
<section class="hero-section">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-7 mb-4 mb-lg-0">
                <h1>Industry Connect Academy</h1>
                <p class="lead">Ghana's Premier Industrial Training Institution</p>
                <p class="mb-4">Professional face-to-face training in Project Management, NDT, HSE, Height Works, Surface Coating, and more. Build your career with internationally recognized certifications.</p>
                <div class="d-flex gap-3 flex-wrap">
                    @auth
                        <a href="{{ route('ica.enrollment') }}" class="btn-primary-ica">
                            <i class="fas fa-file-alt me-2"></i>Enroll Now
                        </a>
                    @else
                        <a href="{{ route('register') }}" class="btn-primary-ica">
                            <i class="fas fa-user-plus me-2"></i>Register to Enroll
                        </a>
                        <a href="{{ route('login') }}" class="btn-outline-ica">
                            <i class="fas fa-sign-in-alt me-2"></i>Login
                        </a>
                    @endauth
                    <a href="#programs" class="btn-outline-ica" onclick="event.preventDefault(); document.getElementById('programs').scrollIntoView({behavior: 'smooth'});">
                        <i class="fas fa-book me-2"></i>View Programs
                    </a>
                </div>
            </div>
            <div class="col-lg-5">
                <div class="row g-3">
                    <div class="col-6">
                        <div class="stat-box">
                            <div class="stat-number">21+</div>
                            <div class="stat-label">Training Programs</div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="stat-box">
                            <div class="stat-number">500+</div>
                            <div class="stat-label">Trained Professionals</div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="stat-box">
                            <div class="stat-number">100%</div>
                            <div class="stat-label">Practical Training</div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="stat-box">
                            <div class="stat-number">5</div>
                            <div class="stat-label">Industry Categories</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Stats Bar -->
<section class="stats-section">
    <div class="container">
        <div class="row text-center">
            <div class="col-md-3 col-6 mb-3 mb-md-0">
                <div class="stat-number">21+</div>
                <div class="stat-label">Programs</div>
            </div>
            <div class="col-md-3 col-6 mb-3 mb-md-0">
                <div class="stat-number">500+</div>
                <div class="stat-label">Students Trained</div>
            </div>
            <div class="col-md-3 col-6">
                <div class="stat-number">100%</div>
                <div class="stat-label">Practical</div>
            </div>
            <div class="col-md-3 col-6">
                <div class="stat-number">5</div>
                <div class="stat-label">Categories</div>
            </div>
        </div>
    </div>
</section>

<!-- Features Section -->
<section class="features-section">
    <div class="container">
        <div class="section-header">
            <h2>Why Choose ICA?</h2>
            <p>Ghana's leading provider of industrial training and certification</p>
        </div>
        <div class="row g-4">
            <div class="col-lg-3 col-md-6">
                <div class="feature-card">
                    <div class="icon"><i class="fas fa-chalkboard-teacher"></i></div>
                    <h5>Expert Instructors</h5>
                    <p>Learn from industry professionals with years of practical experience</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="feature-card">
                    <div class="icon"><i class="fas fa-certificate"></i></div>
                    <h5>International Certification</h5>
                    <p>ASNT, AMPP, and ICA recognized certifications</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="feature-card">
                    <div class="icon"><i class="fas fa-tools"></i></div>
                    <h5>Hands-On Training</h5>
                    <p>100% practical, on-site training with real equipment</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="feature-card">
                    <div class="icon"><i class="fas fa-mobile-alt"></i></div>
                    <h5>Flexible Payment</h5>
                    <p>Mobile Money, Bank Transfer, and online payment options</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Programs Section -->
<section class="programs-section" id="programs">
    <div class="container">
        <div class="section-header">
            <h2>Our Training Programs</h2>
            <p>Choose from <strong>5 specialized categories</strong> with <strong>21 professional programs</strong></p>
            @guest
                <div class="alert alert-warning d-inline-block mt-3">
                    <i class="fas fa-user-lock me-2"></i>
                    <strong>Register an account to enroll in any program</strong>
                </div>
            @endguest
        </div>

        @php
            $programs = \App\Models\IcaProgram::active()->orderBy('category')->orderBy('program_name')->get();
            $programsByCategory = $programs->groupBy('category');
        @endphp

        @foreach($programsByCategory as $category => $categoryPrograms)
        <div class="category-header">
            <div class="d-flex justify-content-between align-items-center flex-wrap">
                <div>
                    <div class="category-title">{{ $category }}</div>
                    <div class="category-count">
                        <i class="fas fa-check-circle text-success me-1"></i>
                        <strong>{{ $categoryPrograms->count() }}</strong> Professional Programs Available
                    </div>
                </div>
                <div class="mt-2 mt-md-0">
                    <span class="badge bg-secondary">On-Site Training</span>
                </div>
            </div>
        </div>

        <div class="row g-4 mb-5">
            @foreach($categoryPrograms as $program)
            <div class="col-lg-4 col-md-6">
                <div class="program-card">
                    <div class="program-image">
                        @if($program->thumbnail && file_exists(public_path('uploads/program_thumbnails/' . $program->thumbnail)))
                            <img src="{{ asset('uploads/program_thumbnails/' . $program->thumbnail) }}" alt="{{ $program->program_name }}">
                        @else
                            <div class="placeholder">
                                <i class="fas fa-graduation-cap"></i>
                            </div>
                        @endif
                        @if($program->price > 0)
                            <div class="program-price">GHS {{ number_format($program->price, 0) }}</div>
                        @else
                            <div class="program-price">Contact Us</div>
                        @endif
                        <div class="program-duration">
                            <i class="fas fa-clock me-1"></i>{{ $program->duration_weeks }} weeks
                        </div>
                    </div>
                    <div class="program-content">
                        <div class="program-title">{{ $program->program_name }}</div>
                        <div class="program-location">
                            <i class="fas fa-map-marker-alt me-1"></i>{{ $program->location }}
                        </div>
                        @if($program->description)
                        <p class="program-description">{{ Str::limit($program->description, 85) }}</p>
                        @endif
                    </div>
                </div>
            </div>
            @endforeach
        </div>
        @endforeach

        <div class="text-center mt-5">
            <div class="help-box d-inline-block" style="max-width: 600px;">
                <h4>Ready to Start Your Training?</h4>
                <p>Join hundreds of professionals trained at Industry Connect Academy</p>
                @auth
                    <a href="{{ route('ica.enrollment') }}" class="btn-primary-ica">
                        <i class="fas fa-file-alt me-2"></i>Submit Expression of Interest
                    </a>
                @else
                    <a href="{{ route('register') }}" class="btn-primary-ica me-2">
                        <i class="fas fa-user-plus me-2"></i>Register to Enroll
                    </a>
                    <a href="{{ route('login') }}" class="btn-outline-ica" style="color: #11273f; border-color: #11273f;">
                        <i class="fas fa-sign-in-alt me-2"></i>Login
                    </a>
                @endauth
            </div>
        </div>
    </div>
</section>

<!-- How to Enroll -->
<section class="steps-section">
    <div class="container">
        <div class="section-header">
            <h2>How to Enroll</h2>
            <p>Simple 4-step process to start your training</p>
        </div>
        <div class="row g-4">
            <div class="col-lg-3 col-md-6">
                <div class="step-item">
                    <div class="step-number">1</div>
                    <h5>Register Account</h5>
                    <p>Create your free account on our platform</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="step-item">
                    <div class="step-number">2</div>
                    <h5>Choose Programs</h5>
                    <p>Select one or multiple training programs</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="step-item">
                    <div class="step-number">3</div>
                    <h5>Pay Enrollment Fee</h5>
                    <p>GHS 100 via Mobile Money or Bank Transfer</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="step-item">
                    <div class="step-number">4</div>
                    <h5>Receive Application</h5>
                    <p>Get formal application letter via email</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="cta-section">
    <div class="container">
        <h2>Ready to Start Your Industrial Career?</h2>
        <p>Join hundreds of professionals trained at Industry Connect Academy</p>
        @auth
            <a href="{{ route('ica.enrollment') }}" class="btn-primary-ica btn-lg">
                <i class="fas fa-file-alt me-2"></i>Enroll Now - GHS 100
            </a>
        @else
            <a href="{{ route('register') }}" class="btn-primary-ica btn-lg me-3">
                <i class="fas fa-user-plus me-2"></i>Create Account
            </a>
            <a href="{{ route('login') }}" class="btn-outline-ica btn-lg">
                <i class="fas fa-sign-in-alt me-2"></i>Login
            </a>
        @endguest
    </div>
</section>

<!-- Contact Section -->
<section class="contact-section">
    <div class="container">
        <div class="section-header">
            <h2>Get In Touch</h2>
            <p>Have questions? We're here to help you start your training journey</p>
        </div>
        
        <div class="row g-4">
            <div class="col-lg-3 col-md-6">
                <div class="contact-info-item">
                    <div class="contact-icon">
                        <i class="fas fa-map-marker-alt"></i>
                    </div>
                    <div>
                        <strong>Location</strong>
                        <span>Accra, Ghana</span>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="contact-info-item">
                    <div class="contact-icon">
                        <i class="fas fa-envelope"></i>
                    </div>
                    <div>
                        <strong>Email</strong>
                        <span>{{ get_settings('system_email') }}</span>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="contact-info-item">
                    <div class="contact-icon">
                        <i class="fas fa-phone"></i>
                    </div>
                    <div>
                        <strong>Phone</strong>
                        <span>+233 (0)54 627 3013</span>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="contact-info-item">
                    <div class="contact-icon">
                        <i class="fas fa-clock"></i>
                    </div>
                    <div>
                        <strong>Office Hours</strong>
                        <span>Mon-Fri, 8AM-5PM</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="text-center mt-5">
            <div class="help-box d-inline-block" style="max-width: 700px;">
                <h4>Need Assistance?</h4>
                <p>Our team is ready to help you with program selection, enrollment process, and payment options. Reach out to us today!</p>
                <a href="{{ route('contact.us') }}" class="btn-primary-ica">
                    <i class="fas fa-paper-plane me-2"></i>Contact Us
                </a>
            </div>
        </div>
    </div>
</section>

@endsection
