@extends('layouts.default')
@push('title', 'Industry Connect Academy - Professional Industrial Training in Ghana')
@push('meta')@endpush
@push('css')
<style>
    :root {
        --ica-primary: #05026c91;
        --ica-secondary: #f2862d;
        --ica-light: #f8f9fa;
        --ica-dark: #05026c91;
    }
    
    body {
        background-color: #FAFEFF;
        font-family: 'Poppins', sans-serif;
    }

    .ica-hero {
        background: linear-gradient(135deg, var(--ica-primary) 0%, #1a3a5f 100%);
        padding: 100px 0 80px;
        position: relative;
        overflow: hidden;
    }

    .ica-hero::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 5px;
        background: linear-gradient(to right, var(--ica-primary), var(--ica-secondary), var(--ica-primary));
    }

    .ica-hero h1 {
        color: white;
        font-size: 3.5rem;
        font-weight: 800;
        text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
    }

    .ica-hero p {
        color: white;
        font-size: 1.3rem;
        text-shadow: 1px 1px 2px rgba(0,0,0,0.2);
    }

    .stats-card {
        background: white;
        border-radius: 15px;
        padding: 30px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        text-align: center;
        transition: transform 0.3s;
    }

    .stats-card:hover {
        transform: translateY(-10px);
    }

    .stats-number {
        font-size: 3rem;
        font-weight: 800;
        background: linear-gradient(135deg, var(--ica-primary), var(--ica-secondary));
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
    }

    .program-category-card {
        background: white;
        border-radius: 15px;
        padding: 30px;
        margin-bottom: 30px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.08);
        border-left: 5px solid var(--ica-secondary);
        transition: all 0.3s;
    }

    .program-category-card:hover {
        box-shadow: 0 10px 40px rgba(0,0,0,0.15);
        transform: translateX(10px);
    }

    .category-icon {
        width: 80px;
        height: 80px;
        background: linear-gradient(135deg, var(--ica-primary), var(--ica-secondary));
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 2.5rem;
        color: white;
        margin-bottom: 20px;
    }

    .btn-ica-primary {
        background: linear-gradient(135deg, var(--ica-secondary), #ff9f4d);
        color: white;
        border: none;
        padding: 15px 40px;
        border-radius: 50px;
        font-weight: 600;
        font-size: 1.1rem;
        transition: all 0.3s;
        box-shadow: 0 5px 15px rgba(242, 134, 45, 0.3);
    }

    .btn-ica-primary:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 25px rgba(242, 134, 45, 0.4);
        color: white;
    }

    .btn-ica-secondary {
        background: white;
        color: var(--ica-primary);
        border: 2px solid var(--ica-primary);
        padding: 15px 40px;
        border-radius: 50px;
        font-weight: 600;
        font-size: 1.1rem;
        transition: all 0.3s;
    }

    .btn-ica-secondary:hover {
        background: var(--ica-primary);
        color: white;
    }

    .feature-box {
        background: white;
        border-radius: 12px;
        padding: 30px;
        text-align: center;
        box-shadow: 0 5px 20px rgba(0,0,0,0.08);
        height: 100%;
        transition: all 0.3s;
    }

    .feature-box:hover {
        box-shadow: 0 10px 40px rgba(0,0,0,0.15);
    }

    .feature-icon {
        font-size: 3rem;
        margin-bottom: 20px;
        background: linear-gradient(135deg, var(--ica-primary), var(--ica-secondary));
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
    }

    .ghana-flag-divider {
        height: 4px;
        background: linear-gradient(to right, var(--ica-primary), var(--ica-secondary), var(--ica-primary));
        margin: 60px 0;
    }

    .testimonial-card {
        background: white;
        border-radius: 15px;
        padding: 30px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.08);
        border-top: 4px solid var(--ica-secondary);
    }

    .cta-section {
        background: linear-gradient(135deg, var(--ica-primary) 0%, #1a3a5f 100%);
        padding: 80px 0;
        color: white;
        text-align: center;
    }

    .program-badge {
        display: inline-block;
        background: var(--ica-secondary);
        color: white;
        padding: 5px 15px;
        border-radius: 20px;
        font-size: 0.85rem;
        font-weight: 600;
        margin-bottom: 10px;
    }

    .price-tag {
        font-size: 1.8rem;
        font-weight: 800;
        color: var(--ica-primary);
    }
</style>
@endpush

@section('content')

<!-- Hero Section -->
<section class="ica-hero">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-7">
                <h1 class="mb-4">Industry Connect Academy</h1>
                <p class="lead mb-4">Ghana's Premier Industrial Training Institution</p>
                <p class="mb-5">Professional face-to-face training in Project Management, NDT, HSE, Height Works, Surface Coating, and more. Build your career with internationally recognized certifications.</p>
                <div class="d-flex gap-3 flex-wrap">
                    @auth
                        <a href="{{ route('ica.enrollment') }}" class="btn btn-ica-primary">
                            <i class="fas fa-file-alt"></i> Enroll Now
                        </a>
                    @else
                        <a href="{{ route('register') }}" class="btn btn-ica-primary">
                            <i class="fas fa-user-plus"></i> Register to Enroll
                        </a>
                        <a href="{{ route('login') }}" class="btn btn-ica-secondary">
                            <i class="fas fa-sign-in-alt"></i> Login
                        </a>
                    @endauth
                    <a href="#programs" class="btn btn-ica-secondary" onclick="event.preventDefault(); document.getElementById('programs').scrollIntoView({behavior: 'smooth'});">
                        <i class="fas fa-book"></i> View Programs
                    </a>
                </div>
            </div>
            <div class="col-lg-5 text-center mt-5 mt-lg-0">
                <div class="row g-3">
                    <div class="col-6">
                        <div class="stats-card">
                            <div class="stats-number">21+</div>
                            <div class="text-muted">Training Programs</div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="stats-card">
                            <div class="stats-number">500+</div>
                            <div class="text-muted">Trained Professionals</div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="stats-card">
                            <div class="stats-number">100%</div>
                            <div class="text-muted">Practical Training</div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="stats-card">
                            <div class="stats-number">5</div>
                            <div class="text-muted">Industry Categories</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Features Section -->
<section class="py-5 bg-light">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="display-5 fw-bold mb-3">Why Choose ICA?</h2>
            <p class="lead text-muted">Ghana's leading provider of industrial training and certification</p>
        </div>
        <div class="row g-4">
            <div class="col-md-3">
                <div class="feature-box">
                    <div class="feature-icon"><i class="fas fa-chalkboard-teacher"></i></div>
                    <h5 class="fw-bold">Expert Instructors</h5>
                    <p class="text-muted">Learn from industry professionals with years of practical experience</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="feature-box">
                    <div class="feature-icon"><i class="fas fa-certificate"></i></div>
                    <h5 class="fw-bold">International Certification</h5>
                    <p class="text-muted">ASNT, AMPP, and ICA recognized certifications</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="feature-box">
                    <div class="feature-icon"><i class="fas fa-tools"></i></div>
                    <h5 class="fw-bold">Hands-On Training</h5>
                    <p class="text-muted">100% practical, on-site training with real equipment</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="feature-box">
                    <div class="feature-icon"><i class="fas fa-mobile-alt"></i></div>
                    <h5 class="fw-bold">Flexible Payment</h5>
                    <p class="text-muted">Mobile Money, Bank Transfer, and online payment options</p>
                </div>
            </div>
        </div>
    </div>
</section>

<div class="ghana-flag-divider"></div>

<!-- Programs Section -->
<section class="py-5 bg-light" id="programs">
    <div class="container">
        <div class="text-center mb-5">
            <span class="badge bg-success px-4 py-2 mb-3" style="font-size: 0.9rem; letter-spacing: 1px;">PROFESSIONAL TRAINING</span>
            <h2 class="display-4 fw-bold mb-3" style="color: var(--ica-primary);">Our Training Programs</h2>
            <p class="lead text-muted mb-4">Choose from <strong>5 specialized categories</strong> with <strong>21 professional programs</strong></p>
            @guest
                <div class="alert alert-warning d-inline-flex align-items-center gap-2 px-4 py-3" style="border-radius: 50px; border: none; box-shadow: 0 4px 15px rgba(0,0,0,0.1);">
                    <i class="fas fa-user-lock" style="font-size: 1.2rem;"></i>
                    <span class="fw-bold">Register an account to enroll in any program</span>
                </div>
            @endguest
        </div>

        @php
            $programs = \App\Models\IcaProgram::active()->orderBy('category')->orderBy('program_name')->get();
            $programsByCategory = $programs->groupBy('category');
        @endphp

        <div class="row g-4">
            @foreach($programsByCategory as $category => $categoryPrograms)
            <div class="col-lg-12 mb-4">
                <div class="program-category-elegant" style="background: white; border-radius: 20px; padding: 35px; box-shadow: 0 10px 40px rgba(0,0,0,0.08); border-left: 6px solid var(--ica-secondary); transition: all 0.3s;">
                    <div class="row align-items-center mb-4">
                        <div class="col-md-8">
                            <div class="d-flex align-items-center gap-3">
                                <div class="category-icon-large" style="width: 70px; height: 70px; background: linear-gradient(135deg, var(--ica-primary), var(--ica-secondary)); border-radius: 16px; display: flex; align-items: center; justify-content: center; font-size: 2rem; color: white; box-shadow: 0 5px 20px rgba(17, 39, 63, 0.3);">
                                    @if(str_contains($category, 'PROJECT'))
                                        <i class="fas fa-project-diagram"></i>
                                    @elseif(str_contains($category, 'HEIGHT'))
                                        <i class="fas fa-hard-hat"></i>
                                    @elseif(str_contains($category, 'CORROSION'))
                                        <i class="fas fa-spray-can"></i>
                                    @elseif(str_contains($category, 'NDT'))
                                        <i class="fas fa-microscope"></i>
                                    @elseif(str_contains($category, 'HSE'))
                                        <i class="fas fa-shield-alt"></i>
                                    @endif
                                </div>
                                <div>
                                    <h3 class="fw-bold mb-1" style="color: var(--ica-primary); font-size: 1.5rem;">{{ $category }}</h3>
                                    <p class="text-muted mb-0">
                                        <i class="fas fa-check-circle text-success"></i> 
                                        <strong>{{ $categoryPrograms->count() }}</strong> Professional Programs Available
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 text-md-end mt-3 mt-md-0">
                            <span class="badge" style="background: linear-gradient(135deg, var(--ica-primary), var(--ica-secondary)); padding: 10px 20px; font-size: 0.9rem; border-radius: 50px;">
                                <i class="fas fa-graduation-cap"></i> On-Site Training
                            </span>
                        </div>
                    </div>
                    
                    <div class="row g-4">
                        @foreach($categoryPrograms as $program)
                        <div class="col-md-6 col-lg-4">
                            <div class="program-card-with-image" style="background: white; border-radius: 15px; overflow: hidden; border: 2px solid #e0e0e0; transition: all 0.3s; cursor: pointer; height: 100%;" onmouseover="this.style.borderColor='var(--ica-secondary)'; this.style.transform='translateY(-5px)'; this.style.boxShadow='0 10px 30px rgba(242, 134, 45, 0.2)';" onmouseout="this.style.borderColor='#e0e0e0'; this.style.transform='translateY(0)'; this.style.boxShadow='none';">
                                <!-- Program Image -->
                                <div class="program-image-wrapper" style="position: relative; height: 200px; overflow: hidden; background: linear-gradient(135deg, var(--ica-primary), var(--ica-secondary));">
                                    @if($program->thumbnail && file_exists(public_path('uploads/program_thumbnails/' . $program->thumbnail)))
                                        <img src="{{ asset('uploads/program_thumbnails/' . $program->thumbnail) }}" alt="{{ $program->program_name }}" style="width: 100%; height: 100%; object-fit: cover;">
                                    @else
                                        <div class="d-flex align-items-center justify-content-center h-100">
                                            <i class="fas fa-graduation-cap" style="font-size: 4rem; color: white; opacity: 0.3;"></i>
                                        </div>
                                    @endif
                                    <!-- Price Badge Overlay -->
                                    <div style="position: absolute; top: 15px; right: 15px;">
                                        @if($program->price > 0)
                                            <div style="background: rgba(17, 39, 63, 0.95); color: white; padding: 8px 15px; border-radius: 8px; font-weight: 700; font-size: 1rem; box-shadow: 0 3px 10px rgba(0,0,0,0.3);">
                                                GHS {{ number_format($program->price, 0) }}
                                            </div>
                                        @else
                                            <span class="badge" style="background: rgba(242, 134, 45, 0.95); padding: 8px 15px; font-size: 0.85rem;">Contact Us</span>
                                        @endif
                                    </div>
                                    <!-- Duration Badge -->
                                    <div style="position: absolute; bottom: 15px; left: 15px;">
                                        <span class="badge" style="background: rgba(255, 255, 255, 0.95); color: var(--ica-primary); padding: 6px 12px; font-size: 0.8rem; font-weight: 600;">
                                            <i class="fas fa-clock me-1"></i> {{ $program->duration_weeks }} weeks
                                        </span>
                                    </div>
                                </div>
                                
                                <!-- Program Content -->
                                <div style="padding: 20px;">
                                    <h6 class="fw-bold mb-2" style="color: var(--ica-primary); font-size: 1.05rem; line-height: 1.4; min-height: 50px;">
                                        {{ $program->program_name }}
                                    </h6>
                                    
                                    <div class="mb-3" style="font-size: 0.85rem; color: #666;">
                                        <i class="fas fa-map-marker-alt" style="color: var(--ica-secondary);"></i> {{ $program->location }}
                                    </div>
                                    
                                    @if($program->description)
                                    <p class="text-muted mb-0" style="font-size: 0.85rem; line-height: 1.6;">
                                        {{ Str::limit($program->description, 80) }}
                                    </p>
                                    @endif
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
            @endforeach
        </div>

        <div class="text-center mt-5">
            <div class="d-inline-block p-4" style="background: white; border-radius: 20px; box-shadow: 0 10px 40px rgba(0,0,0,0.1);">
                <h4 class="fw-bold mb-3" style="color: var(--ica-primary);">Ready to Start Your Training?</h4>
                <p class="text-muted mb-4">Join hundreds of professionals trained at Industry Connect Academy</p>
                @auth
                    <a href="{{ route('ica.enrollment') }}" class="btn btn-ica-primary btn-lg px-5 py-3" style="border-radius: 50px; font-size: 1.1rem; box-shadow: 0 5px 20px rgba(242, 134, 45, 0.3);">
                        <i class="fas fa-file-alt"></i> Submit Expression of Interest
                    </a>
                @else
                    <a href="{{ route('register') }}" class="btn btn-ica-primary btn-lg px-5 py-3 me-2" style="border-radius: 50px; font-size: 1.1rem; box-shadow: 0 5px 20px rgba(242, 134, 45, 0.3);">
                        <i class="fas fa-user-plus"></i> Register to Enroll
                    </a>
                    <a href="{{ route('login') }}" class="btn btn-ica-secondary btn-lg px-5 py-3" style="border-radius: 50px; font-size: 1.1rem;">
                        <i class="fas fa-sign-in-alt"></i> Login
                    </a>
                @endauth
            </div>
        </div>
    </div>
</section>

<div class="ghana-flag-divider"></div>

<!-- How It Works Section -->
<section class="py-5 bg-light">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="display-5 fw-bold mb-3">How to Enroll</h2>
            <p class="lead text-muted">Simple 4-step process to start your training</p>
        </div>
        <div class="row g-4">
            <div class="col-md-3">
                <div class="text-center">
                    <div class="mb-3">
                        <div class="d-inline-flex align-items-center justify-content-center" style="width: 80px; height: 80px; background: linear-gradient(135deg, var(--ica-primary), var(--ica-secondary)); border-radius: 50%; color: white; font-size: 2rem; font-weight: 800;">1</div>
                    </div>
                    <h5 class="fw-bold">Register Account</h5>
                    <p class="text-muted">Create your free account on our platform</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="text-center">
                    <div class="mb-3">
                        <div class="d-inline-flex align-items-center justify-content-center" style="width: 80px; height: 80px; background: linear-gradient(135deg, var(--ica-primary), var(--ica-secondary)); border-radius: 50%; color: white; font-size: 2rem; font-weight: 800;">2</div>
                    </div>
                    <h5 class="fw-bold">Choose Programs</h5>
                    <p class="text-muted">Select one or multiple training programs</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="text-center">
                    <div class="mb-3">
                        <div class="d-inline-flex align-items-center justify-content-center" style="width: 80px; height: 80px; background: linear-gradient(135deg, var(--ica-primary), var(--ica-secondary)); border-radius: 50%; color: white; font-size: 2rem; font-weight: 800;">3</div>
                    </div>
                    <h5 class="fw-bold">Pay Enrollment Fee</h5>
                    <p class="text-muted">GHS 100 via Mobile Money or Bank Transfer</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="text-center">
                    <div class="mb-3">
                        <div class="d-inline-flex align-items-center justify-content-center" style="width: 80px; height: 80px; background: linear-gradient(135deg, var(--ica-primary), var(--ica-secondary)); border-radius: 50%; color: white; font-size: 2rem; font-weight: 800;">4</div>
                    </div>
                    <h5 class="fw-bold">Receive Application</h5>
                    <p class="text-muted">Get formal application letter via email</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="cta-section">
    <div class="container">
        <h2 class="display-4 fw-bold mb-4">Ready to Start Your Industrial Career?</h2>
        <p class="lead mb-5">Join hundreds of professionals trained at Industry Connect Academy</p>
        @auth
            <a href="{{ route('ica.enrollment') }}" class="btn btn-light btn-lg px-5 py-3">
                <i class="fas fa-file-alt"></i> Enroll Now - GHS 100
            </a>
        @else
            <a href="{{ route('register') }}" class="btn btn-light btn-lg px-5 py-3 me-3">
                <i class="fas fa-user-plus"></i> Create Account
            </a>
            <a href="{{ route('login') }}" class="btn btn-outline-light btn-lg px-5 py-3">
                <i class="fas fa-sign-in-alt"></i> Login
            </a>
        @endguest
    </div>
</section>

<!-- Contact Section -->
<section class="py-5">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <h2 class="display-6 fw-bold mb-4">Contact Industry Connect Academy</h2>
                <div class="mb-3">
                    <i class="fas fa-map-marker-alt text-danger me-2"></i>
                    <strong>Location:</strong> Accra, Ghana
                </div>
                <div class="mb-3">
                    <i class="fas fa-envelope text-primary me-2"></i>
                    <strong>Email:</strong> info@icaghana.com
                </div>
                <div class="mb-3">
                    <i class="fas fa-phone text-success me-2"></i>
                    <strong>Phone:</strong> +233 XX XXX XXXX
                </div>
                <div class="mb-3">
                    <i class="fas fa-clock text-warning me-2"></i>
                    <strong>Office Hours:</strong> Mon-Fri, 8:00 AM - 5:00 PM
                </div>
            </div>
            <div class="col-lg-6">
                <div class="p-4" style="background: linear-gradient(135deg, var(--ica-primary), var(--ica-secondary)); border-radius: 15px; color: white;">
                    <h4 class="fw-bold mb-3">Need Help?</h4>
                    <p>Our team is ready to assist you with program selection, enrollment process, and payment options.</p>
                    <a href="{{ route('contact.us') }}" class="btn btn-light btn-lg mt-3">
                        <i class="fas fa-paper-plane"></i> Send Message
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

@endsection
