@extends('layouts.default')
@push('title', 'About Us - Industry Connect Academy')
@push('meta')
    <meta name="description" content="Industry Connect Academy offers hands-on, industry-certified training in NDT, Scaffolding, Blasting & Coating, Lifting Inspection, and Safety programs.">
@endpush
@push('css')
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
<style>
    :root {
        --ica-primary: #11273f;
        --ica-secondary: #f2862d;
        --ghana-green: #006B3F;
        --ghana-gold: #FCD116;
    }

    * {
        font-family: 'Inter', sans-serif;
    }

    .about-hero {
        background: linear-gradient(135deg, var(--ica-primary) 0%, #1a3a5f 100%);
        color: white;
        padding: 100px 0 80px;
        position: relative;
        overflow: hidden;
    }

    .about-hero::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('data:image/svg+xml,<svg width="100" height="100" xmlns="http://www.w3.org/2000/svg"><rect width="2" height="2" fill="rgba(255,255,255,0.1)"/></svg>');
        background-size: 50px 50px;
        opacity: 0.3;
    }

    .about-hero-content {
        position: relative;
        z-index: 2;
        text-align: center;
    }

    .about-hero h1 {
        font-size: 3.5rem;
        font-weight: 900;
        margin-bottom: 20px;
        text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
    }

    .about-hero p {
        font-size: 1.3rem;
        opacity: 0.95;
        max-width: 800px;
        margin: 0 auto;
    }

    .about-section {
        padding: 80px 0;
    }

    .section-title {
        font-size: 2.5rem;
        font-weight: 800;
        color: var(--ica-primary);
        margin-bottom: 15px;
        position: relative;
        display: inline-block;
    }

    .section-title::after {
        content: '';
        position: absolute;
        bottom: -10px;
        left: 0;
        width: 80px;
        height: 4px;
        background: var(--ica-secondary);
        border-radius: 2px;
    }

    .section-subtitle {
        font-size: 1.2rem;
        color: #666;
        line-height: 1.8;
        margin-bottom: 40px;
    }

    .mission-card {
        background: white;
        border-radius: 20px;
        padding: 50px;
        box-shadow: 0 15px 50px rgba(0,0,0,0.1);
        border-left: 6px solid var(--ica-secondary);
        margin-bottom: 30px;
    }

    .mission-card h3 {
        font-size: 1.8rem;
        font-weight: 700;
        color: var(--ica-primary);
        margin-bottom: 20px;
    }

    .mission-card p {
        font-size: 1.1rem;
        color: #555;
        line-height: 1.9;
        margin-bottom: 15px;
    }

    .program-card {
        background: white;
        border-radius: 20px;
        padding: 35px;
        height: 100%;
        box-shadow: 0 10px 40px rgba(0,0,0,0.08);
        transition: all 0.3s;
        border-top: 5px solid var(--ica-secondary);
    }

    .program-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 20px 60px rgba(0,0,0,0.15);
    }

    .program-icon {
        width: 70px;
        height: 70px;
        background: linear-gradient(135deg, var(--ica-primary), var(--ica-secondary));
        border-radius: 16px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 2rem;
        color: white;
        margin-bottom: 20px;
        box-shadow: 0 8px 25px rgba(17, 39, 63, 0.3);
    }

    .program-title {
        font-size: 1.3rem;
        font-weight: 700;
        color: var(--ica-primary);
        margin-bottom: 15px;
    }

    .program-description {
        font-size: 1rem;
        color: #666;
        line-height: 1.7;
    }

    .requirements-section {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    }

    .requirement-item {
        background: white;
        border-radius: 15px;
        padding: 25px;
        margin-bottom: 15px;
        display: flex;
        align-items: center;
        gap: 20px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.05);
        transition: all 0.3s;
    }

    .requirement-item:hover {
        transform: translateX(10px);
        box-shadow: 0 8px 30px rgba(0,0,0,0.1);
    }

    .requirement-icon {
        width: 50px;
        height: 50px;
        background: linear-gradient(135deg, var(--ica-secondary), #ff9f4d);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 1.3rem;
        flex-shrink: 0;
    }

    .requirement-text {
        font-size: 1.1rem;
        color: #333;
        font-weight: 500;
    }

    .perfect-for-section {
        background: white;
    }

    .perfect-for-card {
        background: linear-gradient(135deg, var(--ica-primary), #1a3a5f);
        color: white;
        border-radius: 20px;
        padding: 30px;
        height: 100%;
        transition: all 0.3s;
        position: relative;
        overflow: hidden;
    }

    .perfect-for-card::before {
        content: '';
        position: absolute;
        top: -50px;
        right: -50px;
        width: 150px;
        height: 150px;
        background: var(--ica-secondary);
        border-radius: 50%;
        opacity: 0.2;
    }

    .perfect-for-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 40px rgba(17, 39, 63, 0.3);
    }

    .perfect-for-icon {
        font-size: 2.5rem;
        margin-bottom: 20px;
        color: var(--ica-secondary);
    }

    .perfect-for-title {
        font-size: 1.2rem;
        font-weight: 700;
        margin-bottom: 10px;
    }

    .perfect-for-text {
        font-size: 1rem;
        opacity: 0.9;
        line-height: 1.6;
    }

    .why-choose-section {
        background: linear-gradient(135deg, var(--ica-primary) 0%, #1a3a5f 100%);
        color: white;
        position: relative;
        overflow: hidden;
    }

    .why-choose-section::before {
        content: '';
        position: absolute;
        top: -100px;
        left: -100px;
        width: 300px;
        height: 300px;
        background: var(--ica-secondary);
        border-radius: 50%;
        opacity: 0.1;
    }

    .why-item {
        background: rgba(255, 255, 255, 0.1);
        border-radius: 15px;
        padding: 30px;
        margin-bottom: 20px;
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.2);
        transition: all 0.3s;
    }

    .why-item:hover {
        background: rgba(255, 255, 255, 0.15);
        transform: translateX(10px);
    }

    .why-icon {
        width: 60px;
        height: 60px;
        background: var(--ica-secondary);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.5rem;
        margin-bottom: 20px;
    }

    .why-title {
        font-size: 1.4rem;
        font-weight: 700;
        margin-bottom: 10px;
    }

    .why-text {
        font-size: 1rem;
        opacity: 0.95;
        line-height: 1.7;
    }

    .cta-section {
        background: var(--ica-secondary);
        color: white;
        padding: 60px 0;
        text-align: center;
    }

    .cta-section h2 {
        font-size: 2.5rem;
        font-weight: 800;
        margin-bottom: 20px;
    }

    .cta-section p {
        font-size: 1.2rem;
        margin-bottom: 30px;
    }

    .btn-cta {
        background: white;
        color: var(--ica-primary);
        padding: 18px 50px;
        border-radius: 50px;
        font-weight: 700;
        font-size: 1.1rem;
        text-decoration: none;
        transition: all 0.3s;
        display: inline-block;
        box-shadow: 0 8px 25px rgba(0,0,0,0.2);
    }

    .btn-cta:hover {
        transform: translateY(-3px);
        box-shadow: 0 12px 35px rgba(0,0,0,0.3);
        color: var(--ica-primary);
    }

    @media (max-width: 991px) {
        .about-hero h1 {
            font-size: 2.5rem;
        }
        .section-title {
            font-size: 2rem;
        }
    }

    @media (max-width: 767px) {
        .about-hero h1 {
            font-size: 2rem;
        }
        .mission-card {
            padding: 30px;
        }
    }
</style>
@endpush

@section('content')
<!-- Hero Section -->
<section class="about-hero">
    <div class="container">
        <div class="about-hero-content">
            <h1>About Industry Connect Academy</h1>
            <p>Africa's Future of Technical Competence</p>
        </div>
    </div>
</section>

<!-- Mission Section -->
<section class="about-section">
    <div class="container">
        <div class="mission-card">
            <h3>Who We Are</h3>
            <p>
                <strong>Industry Connect Academy (ICA)</strong> offers hands-on, industry-certified training in critical technical fields. 
                We specialize in <strong>Non-Destructive Testing (NDT)</strong> for quality control in petroleum, power, and mining; 
                <strong>Scaffolding</strong> for safe design, construction, and compliance with global standards; 
                <strong>Blasting & Coating</strong> for surface preparation and corrosion control; 
                <strong>Lifting Inspection</strong> for load testing and rigging; and comprehensive <strong>Safety</strong> programs for workplace safety compliance.
            </p>
            <p>
                Our programs combine classroom learning, hands-on practice, and certification using state-of-the-art equipment. 
                Open to youth, especially in technical fields, we offer globally recognized certifications, real-world skills, and job opportunities.
            </p>
        </div>

        <div class="mission-card">
            <h3>Our Belief: Technical Training for Everyone</h3>
            <p>
                We believe that technical training should be accessible to everyone—not just engineers or university graduates. 
                Whether you're a recent SHS/TVET graduate, a job seeker with no technical background, or someone looking for a fresh start, 
                you can gain in-demand, industry-ready skills in just <strong>4 to 6 weeks</strong>.
            </p>
            <p>
                Our practical programs are designed to prepare you for real jobs across <strong>Oil & Gas, Construction, Mining, Power, and Manufacturing</strong>—sectors 
                that offer high growth and high pay, both locally and globally.
            </p>
        </div>
    </div>
</section>

<!-- Training Programs Section -->
<section class="about-section" style="background: #f8f9fa;">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="section-title">Our Hands-On Training Programs</h2>
            <p class="section-subtitle">Industry-certified programs designed for real-world success</p>
        </div>

        <div class="row g-4">
            <div class="col-lg-4 col-md-6">
                <div class="program-card">
                    <div class="program-icon">
                        <i class="fas fa-microscope"></i>
                    </div>
                    <h4 class="program-title">Non-Destructive Testing (NDT)</h4>
                    <p class="program-description">
                        Inspect materials and equipment without damaging them—used in oil rigs, pipelines, and plants. 
                        Essential for quality control in petroleum, power, and mining industries.
                    </p>
                </div>
            </div>

            <div class="col-lg-4 col-md-6">
                <div class="program-card">
                    <div class="program-icon">
                        <i class="fas fa-project-diagram"></i>
                    </div>
                    <h4 class="program-title">Microsoft Project</h4>
                    <p class="program-description">
                        Learn professional project management skills with industry-standard software. 
                        No technical background needed—perfect for anyone entering project coordination roles.
                    </p>
                </div>
            </div>

            <div class="col-lg-4 col-md-6">
                <div class="program-card">
                    <div class="program-icon">
                        <i class="fas fa-rope"></i>
                    </div>
                    <h4 class="program-title">Rope Access</h4>
                    <p class="program-description">
                        Train in high-access operations using ropes instead of scaffolds—essential for offshore, 
                        construction, and power sectors. IRATA-aligned training.
                    </p>
                </div>
            </div>

            <div class="col-lg-4 col-md-6">
                <div class="program-card">
                    <div class="program-icon">
                        <i class="fas fa-hard-hat"></i>
                    </div>
                    <h4 class="program-title">Scaffolding</h4>
                    <p class="program-description">
                        Learn to safely erect and dismantle scaffolds in compliance with site safety regulations. 
                        OSHA-aligned and CISRS-inspired training for construction and industrial sites.
                    </p>
                </div>
            </div>

            <div class="col-lg-4 col-md-6">
                <div class="program-card">
                    <div class="program-icon">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <h4 class="program-title">Health, Safety & Environment (HSE)</h4>
                    <p class="program-description">
                        Get certified in workplace safety practices that prevent accidents and save lives. 
                        Internationally recognized HSE certifications for all industries.
                    </p>
                </div>
            </div>

            <div class="col-lg-4 col-md-6">
                <div class="program-card">
                    <div class="program-icon">
                        <i class="fas fa-anchor"></i>
                    </div>
                    <h4 class="program-title">Lifting Equipment Inspection</h4>
                    <p class="program-description">
                        Master the skills needed to inspect cranes, chains, and lifting gear—ensuring safety 
                        and legal compliance in construction and industrial operations.
                    </p>
                </div>
            </div>

            <div class="col-lg-4 col-md-6">
                <div class="program-card">
                    <div class="program-icon">
                        <i class="fas fa-spray-can"></i>
                    </div>
                    <h4 class="program-title">Blasting & Coating</h4>
                    <p class="program-description">
                        Gain expertise in surface preparation and industrial painting—key for corrosion protection 
                        in pipelines, vessels, and ships. NACE-aligned training.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Requirements Section -->
<section class="about-section requirements-section">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="section-title">Who Can Enroll?</h2>
            <p class="section-subtitle">Open to all backgrounds—technical or non-technical</p>
        </div>

        <div class="row">
            <div class="col-lg-6">
                <h3 style="color: var(--ica-primary); font-weight: 700; margin-bottom: 30px;">
                    <i class="fas fa-clipboard-check me-2" style="color: var(--ica-secondary);"></i>
                    Requirements
                </h3>
                <div class="requirement-item">
                    <div class="requirement-icon">
                        <i class="fas fa-graduation-cap"></i>
                    </div>
                    <div class="requirement-text">SHS or TVET graduate or higher</div>
                </div>
                <div class="requirement-item">
                    <div class="requirement-icon">
                        <i class="fas fa-calculator"></i>
                    </div>
                    <div class="requirement-text">Basic math or science knowledge is helpful</div>
                </div>
                <div class="requirement-item">
                    <div class="requirement-icon">
                        <i class="fas fa-dumbbell"></i>
                    </div>
                    <div class="requirement-text">Physically fit (for programs like Rope Access or Scaffolding)</div>
                </div>
                <div class="requirement-item">
                    <div class="requirement-icon">
                        <i class="fas fa-calendar-alt"></i>
                    </div>
                    <div class="requirement-text">Must be 18 years or older</div>
                </div>
            </div>

            <div class="col-lg-6">
                <h3 style="color: var(--ica-primary); font-weight: 700; margin-bottom: 30px;">
                    <i class="fas fa-users me-2" style="color: var(--ica-secondary);"></i>
                    Perfect For
                </h3>
                <div class="row g-3">
                    <div class="col-md-6">
                        <div class="perfect-for-card">
                            <div class="perfect-for-icon">
                                <i class="fas fa-user-graduate"></i>
                            </div>
                            <div class="perfect-for-title">SHS/TVET Graduates</div>
                            <div class="perfect-for-text">Seeking job-ready technical skills</div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="perfect-for-card">
                            <div class="perfect-for-icon">
                                <i class="fas fa-briefcase"></i>
                            </div>
                            <div class="perfect-for-title">Job Seekers</div>
                            <div class="perfect-for-text">Looking to enter booming industries</div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="perfect-for-card">
                            <div class="perfect-for-icon">
                                <i class="fas fa-certificate"></i>
                            </div>
                            <div class="perfect-for-title">Career Changers</div>
                            <div class="perfect-for-text">Needing international certifications</div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="perfect-for-card">
                            <div class="perfect-for-icon">
                                <i class="fas fa-female"></i>
                            </div>
                            <div class="perfect-for-title">Women in STEM</div>
                            <div class="perfect-for-text">Ready to explore technical careers</div>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="perfect-for-card">
                            <div class="perfect-for-icon">
                                <i class="fas fa-hands-helping"></i>
                            </div>
                            <div class="perfect-for-title">Anyone Seeking Practical Skills</div>
                            <div class="perfect-for-text">Moving from classroom theory to hands-on field practice</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Why Choose ICA Section -->
<section class="about-section why-choose-section">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="section-title" style="color: white;">Why Choose ICA?</h2>
            <p class="section-subtitle" style="color: rgba(255,255,255,0.9);">
                Your pathway to a successful technical career
            </p>
        </div>

        <div class="row">
            <div class="col-lg-6">
                <div class="why-item">
                    <div class="why-icon">
                        <i class="fas fa-clock"></i>
                    </div>
                    <h4 class="why-title">Short-Term, High-Impact</h4>
                    <p class="why-text">
                        Complete training in just 4–6 weeks and become employable immediately. 
                        No need for years of study—get job-ready fast.
                    </p>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="why-item">
                    <div class="why-icon">
                        <i class="fas fa-globe"></i>
                    </div>
                    <h4 class="why-title">Globally Recognized Certifications</h4>
                    <p class="why-text">
                        Programs aligned with ISO, ASNT, IRATA, OSHA, NACE, and other international bodies. 
                        Your certificate opens doors worldwide.
                    </p>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="why-item">
                    <div class="why-icon">
                        <i class="fas fa-chalkboard-teacher"></i>
                    </div>
                    <h4 class="why-title">Taught by Experts</h4>
                    <p class="why-text">
                        Learn from certified professionals with real industry experience. 
                        Our instructors bring practical knowledge from the field.
                    </p>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="why-item">
                    <div class="why-icon">
                        <i class="fas fa-tools"></i>
                    </div>
                    <h4 class="why-title">Job-Ready Skills</h4>
                    <p class="why-text">
                        Our programs are tailored to match what employers in Ghana and abroad actually need. 
                        Train on real equipment, not just theory.
                    </p>
                </div>
            </div>

            <div class="col-lg-12">
                <div class="why-item">
                    <div class="why-icon">
                        <i class="fas fa-heart"></i>
                    </div>
                    <h4 class="why-title">Inclusive & Supportive</h4>
                    <p class="why-text">
                        We welcome all backgrounds—technical or not. Our supportive learning environment 
                        ensures everyone succeeds, regardless of their starting point.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="cta-section">
    <div class="container">
        <h2>Ready to Transform Your Career?</h2>
        <p>Join hundreds of graduates who are now working in high-demand technical roles</p>
        <a href="{{ route('ica.enrollment') }}" class="btn-cta">
            <i class="fas fa-rocket me-2"></i> Apply Now
        </a>
    </div>
</section>
@endsection

@push('js')
<script>
    "use strict";
</script>
@endpush
