@extends('layouts.default')
@push('title', 'Contact Us - Industry Connect Academy')
@push('meta')@endpush
@push('css')
<style>
    :root {
        --ica-navy: #11273f;
        --ica-orange: #f2862d;
    }

    .contact-hero {
        background: linear-gradient(165deg, #0a1829 0%, #11273f 45%, #1a3a5f 100%);
        padding: 80px 0;
        position: relative;
        overflow: hidden;
    }

    .contact-hero::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: radial-gradient(circle at 20% 50%, rgba(242, 134, 45, 0.08) 0%, transparent 50%);
        pointer-events: none;
    }

    .contact-hero h1 {
        color: white;
        font-size: 3rem;
        font-weight: 700;
        margin-bottom: 1rem;
        letter-spacing: -1px;
    }

    .contact-hero p {
        color: rgba(255,255,255,0.85);
        font-size: 1.15rem;
        max-width: 600px;
        margin: 0 auto;
    }

    .contact-card {
        background: white;
        border: 1px solid #e8eaed;
        border-radius: 14px;
        padding: 35px;
        height: 100%;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        position: relative;
        overflow: hidden;
    }

    .contact-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(90deg, #f2862d, #ff9f4d);
        transform: scaleX(0);
        transform-origin: left;
        transition: transform 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .contact-card:hover {
        border-color: rgba(242, 134, 45, 0.3);
        box-shadow: 0 12px 32px rgba(17, 39, 63, 0.1);
        transform: translateY(-6px);
    }

    .contact-card:hover::before {
        transform: scaleX(1);
    }

    .contact-icon {
        width: 70px;
        height: 70px;
        background: linear-gradient(135deg, #f2862d, #ff9f4d);
        border-radius: 14px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-bottom: 25px;
        box-shadow: 0 6px 20px rgba(242, 134, 45, 0.3);
        transition: transform 0.3s ease;
    }

    .contact-card:hover .contact-icon {
        transform: scale(1.1);
    }

    .contact-icon i {
        font-size: 2rem;
        color: white;
    }

    .contact-card h4 {
        color: #11273f;
        font-size: 1.3rem;
        font-weight: 600;
        margin-bottom: 0.75rem;
        letter-spacing: -0.3px;
    }

    .contact-card p {
        color: #6c757d;
        margin-bottom: 1rem;
        line-height: 1.6;
    }

    .contact-card a {
        color: #f2862d;
        font-weight: 500;
        text-decoration: none;
        transition: color 0.2s;
    }

    .contact-card a:hover {
        color: #e07825;
    }

    .contact-form-section {
        background: #f8f9fb;
        padding: 80px 0;
    }

    .form-card {
        background: white;
        border: 1px solid #e8eaed;
        border-radius: 14px;
        padding: 45px;
        box-shadow: 0 6px 20px rgba(0,0,0,0.07);
    }

    .form-card h3 {
        color: #11273f;
        font-size: 2rem;
        font-weight: 700;
        margin-bottom: 1.5rem;
        letter-spacing: -0.5px;
    }

    .form-label {
        color: #11273f;
        font-weight: 600;
        margin-bottom: 0.5rem;
        font-size: 0.95rem;
    }

    .form-control, .form-select {
        border: 1.5px solid #e8eaed;
        border-radius: 8px;
        padding: 12px 16px;
        font-size: 0.95rem;
        transition: all 0.2s;
    }

    .form-control:focus, .form-select:focus {
        border-color: #f2862d;
        box-shadow: 0 0 0 0.2rem rgba(242, 134, 45, 0.15);
    }

    .btn-submit {
        background: linear-gradient(135deg, #f2862d 0%, #ff9f4d 100%);
        color: white;
        border: none;
        padding: 14px 40px;
        border-radius: 8px;
        font-weight: 600;
        font-size: 1rem;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        box-shadow: 0 6px 20px rgba(242, 134, 45, 0.3);
        letter-spacing: 0.3px;
    }

    .btn-submit:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 28px rgba(242, 134, 45, 0.4);
    }

    .map-section {
        height: 400px;
        border-radius: 14px;
        overflow: hidden;
        box-shadow: 0 6px 20px rgba(0,0,0,0.1);
    }

    .map-section iframe {
        width: 100%;
        height: 100%;
        border: none;
    }
</style>
@endpush

@section('content')
<!-- Hero Section -->
<section class="contact-hero text-center">
    <div class="container">
        <h1>Get In Touch</h1>
        <p>Have questions about our training programs? We're here to help you start your professional journey with Industry Connect Academy.</p>
    </div>
</section>

<!-- Contact Cards -->
<section class="py-5" style="margin-top: -50px;">
    <div class="container">
        @php
            $contact_info = get_frontend_settings('contact_info');
            if ($contact_info) {
                $contact_info = json_decode($contact_info, true);
            } else {
                $contact_info = ['email' => 'info@ica.com', 'phone' => '+233 (0)54 627 3013', 'address' => 'Accra, Ghana', 'office_hours' => 'Mon-Fri, 8:00 AM - 5:00 PM'];
            }
        @endphp
        
        <div class="row g-4">
            <div class="col-lg-4 col-md-6">
                <div class="contact-card">
                    <div class="contact-icon">
                        <i class="fas fa-map-marker-alt"></i>
                    </div>
                    <h4>Our Location</h4>
                    <p>Visit us at our training center</p>
                    <a href="#">{{ $contact_info['address'] ?? 'Accra, Ghana' }}</a>
                </div>
            </div>

            <div class="col-lg-4 col-md-6">
                <div class="contact-card">
                    <div class="contact-icon">
                        <i class="fas fa-envelope"></i>
                    </div>
                    <h4>Email Us</h4>
                    <p>Send us your inquiries</p>
                    <a href="mailto:{{ $contact_info['email'] ?? get_settings('system_email') }}">{{ $contact_info['email'] ?? get_settings('system_email') }}</a>
                </div>
            </div>

            <div class="col-lg-4 col-md-6">
                <div class="contact-card">
                    <div class="contact-icon">
                        <i class="fas fa-phone"></i>
                    </div>
                    <h4>Call Us</h4>
                    <p>Speak with our team</p>
                    <a href="tel:{{ str_replace(' ', '', $contact_info['phone'] ?? '+233546273013') }}">{{ $contact_info['phone'] ?? '+233 (0)54 627 3013' }}</a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Contact Form Section -->
<section class="contact-form-section">
    <div class="container">
        <div class="row g-5">
            <div class="col-lg-6">
                <div class="form-card">
                    <h3>Send Us a Message</h3>
                    <p class="text-muted mb-4">Fill out the form below and we'll get back to you as soon as possible.</p>
                    
                    <form action="{{ route('contact.store') }}" method="POST">
                        @csrf
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Full Name *</label>
                                <input type="text" name="name" class="form-control" placeholder="Your name" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Email Address *</label>
                                <input type="email" name="email" class="form-control" placeholder="your@email.com" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Phone Number</label>
                                <input type="tel" name="phone" class="form-control" placeholder="+233 XX XXX XXXX">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Subject</label>
                                <select name="subject" class="form-select">
                                    <option value="">Select a subject</option>
                                    <option value="General Inquiry">General Inquiry</option>
                                    <option value="Program Information">Program Information</option>
                                    <option value="Enrollment">Enrollment</option>
                                    <option value="Payment">Payment</option>
                                    <option value="Other">Other</option>
                                </select>
                            </div>
                            <div class="col-12">
                                <label class="form-label">Message *</label>
                                <textarea name="message" class="form-control" rows="5" placeholder="Tell us how we can help you..." required></textarea>
                            </div>
                            <div class="col-12">
                                <button type="submit" class="btn btn-submit">
                                    <i class="fas fa-paper-plane me-2"></i>Send Message
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="mb-4">
                    <h3 class="fw-bold text-navy mb-3">Office Hours</h3>
                    <div class="contact-card">
                        <div class="d-flex align-items-start gap-3 mb-3">
                            <div class="contact-icon" style="width: 50px; height: 50px;">
                                <i class="fas fa-clock" style="font-size: 1.3rem;"></i>
                            </div>
                            <div>
                                <h5 class="mb-2 text-navy">Working Hours</h5>
                                <p class="mb-1"><strong>Monday - Friday:</strong> 8:00 AM - 5:00 PM</p>
                                <p class="mb-0"><strong>Saturday - Sunday:</strong> Closed</p>
                            </div>
                        </div>
                    </div>
                </div>

                @if(isset($contact_info['location']) && $contact_info['location'])
                <div class="map-section">
                    <iframe src="{{ $contact_info['location'] }}" allowfullscreen="" loading="lazy"></iframe>
                </div>
                @else
                <div class="map-section">
                    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3970.8267779757!2d-0.1870!3d5.6037!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x0!2zNcKwMzYnMTMuMyJOIDDCsDExJzEzLjIiVw!5e0!3m2!1sen!2sgh!4v1234567890" allowfullscreen="" loading="lazy"></iframe>
                </div>
                @endif
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-5" style="background: linear-gradient(165deg, #0a1829 0%, #11273f 45%, #1a3a5f 100%);">
    <div class="container text-center text-white">
        <h2 class="mb-3">Ready to Start Your Training?</h2>
        <p class="mb-4" style="color: rgba(255,255,255,0.85); font-size: 1.1rem;">Join hundreds of professionals trained at Industry Connect Academy</p>
        @auth
            <a href="{{ route('ica.enrollment') }}" class="btn btn-submit btn-lg">
                <i class="fas fa-file-alt me-2"></i>Enroll Now
            </a>
        @else
            <a href="{{ route('register') }}" class="btn btn-submit btn-lg me-3">
                <i class="fas fa-user-plus me-2"></i>Register
            </a>
            <a href="{{ route('login') }}" class="btn btn-lg" style="background: rgba(255, 255, 255, 0.15); color: white; border: 2px solid rgba(255, 255, 255, 0.3); padding: 13px 36px; border-radius: 8px;">
                <i class="fas fa-sign-in-alt me-2"></i>Login
            </a>
        @endauth
    </div>
</section>

@endsection

@push('js')
<script>
    @if(session('success'))
        toastr.success('{{ session('success') }}');
    @endif
    @if(session('error'))
        toastr.error('{{ session('error') }}');
    @endif
</script>
@endpush
