@extends('layouts.default')
@push('title', 'ICA Course Enrollment - Industry Connect Academy')
@push('meta')@endpush
@push('css')
<style>
    .ica-hero {
        background: linear-gradient(135deg, #006B3F 0%, #FCD116 100%);
        padding: 80px 0;
        color: white;
    }
    .ica-card {
        border: none;
        border-radius: 12px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.1);
        transition: transform 0.3s;
    }
    .ica-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 30px rgba(0,0,0,0.15);
    }
    .ghana-colors {
        border-left: 4px solid #CE1126;
        border-right: 4px solid #006B3F;
    }
    .program-category {
        background: linear-gradient(to right, #006B3F, #FCD116);
        color: white;
        padding: 15px;
        border-radius: 8px;
        margin-bottom: 20px;
    }
    .program-item {
        background: white;
        padding: 15px;
        margin: 10px 0;
        border-radius: 8px;
        border-left: 4px solid #CE1126;
    }
    .program-item:hover {
        background: #f8f9fa;
    }
    .enrollment-form {
        background: white;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.1);
    }
    .btn-ghana {
        background: linear-gradient(135deg, #006B3F 0%, #CE1126 100%);
        color: white;
        border: none;
        padding: 12px 30px;
        border-radius: 8px;
        font-weight: 600;
    }
    .btn-ghana:hover {
        background: linear-gradient(135deg, #CE1126 0%, #006B3F 100%);
        color: white;
    }
    .payment-option {
        border: 2px solid #e0e0e0;
        padding: 20px;
        border-radius: 8px;
        cursor: pointer;
        transition: all 0.3s;
    }
    .payment-option:hover {
        border-color: #006B3F;
        background: #f8f9fa;
    }
    .payment-option.active {
        border-color: #006B3F;
        background: #e8f5e9;
    }
    .star-icon {
        color: #FCD116;
    }
</style>
@endpush

@section('content')
<!-- ICA Hero Section -->
<section class="ica-hero">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8">
                <h1 class="display-4 fw-bold mb-3">Industry Connect Academy (ICA)</h1>
                <h2 class="h3 mb-4">Expression of Interest – Course Enrollment</h2>
                <p class="lead">Prospective trainees are invited to express their interest in joining Industry Connect Academy (ICA) programs. Once an EOI is submitted, applicants will receive a formal application letter outlining program requirements, admission details, PPE, and payment instructions.</p>
                <div class="d-flex gap-3 mt-4">
                    <div class="text-center">
                        <div class="h2 fw-bold mb-0">500+</div>
                        <small>Trained Professionals</small>
                    </div>
                    <div class="text-center">
                        <div class="h2 fw-bold mb-0">13</div>
                        <small>Industry Programs</small>
                    </div>
                    <div class="h2 fw-bold mb-0">100%</div>
                        <small>Practical Training</small>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 text-center">
                <img src="{{ asset('assets/frontend/default/image/ghana-flag.png') }}" alt="Ghana Flag" class="img-fluid" style="max-width: 200px;">
            </div>
        </div>
    </div>
</section>

<!-- Programs Overview -->
<section class="py-5 bg-light">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="display-5 fw-bold mb-3">ICA Training Programs</h2>
            <p class="lead text-muted">Face-to-face, on-site training with online enrollment and flexible payment options</p>
        </div>

        @foreach($programsByCategory as $category => $programs)
        <div class="program-category mb-4">
            <h3 class="h4 mb-0">{{ $category }}</h3>
        </div>
        
        <div class="row mb-5">
            @foreach($programs as $program)
            <div class="col-md-6 mb-3">
                <div class="program-item">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <h5 class="fw-bold mb-2">{{ $program->program_name }}</h5>
                            <p class="text-muted small mb-2">{{ Str::limit($program->description, 120) }}</p>
                            <div class="d-flex gap-3 small">
                                <span><i class="fas fa-clock"></i> {{ $program->duration_weeks }} weeks</span>
                                <span><i class="fas fa-map-marker-alt"></i> {{ $program->location }}</span>
                            </div>
                        </div>
                        <div class="text-end">
                            <div class="h5 fw-bold text-success mb-0">GHS {{ number_format($program->price, 2) }}</div>
                            <small class="text-muted">Program Fee</small>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
        @endforeach
    </div>
</section>

<!-- Enrollment Form -->
<section class="py-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="enrollment-form ghana-colors">
                    <h2 class="text-center mb-4">Submit Your Expression of Interest</h2>
                    <p class="text-center text-muted mb-5">Complete the form below to begin your enrollment process</p>

                    @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle"></i> {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                    @endif

                    @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-circle"></i> {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                    @endif

                    <form action="{{ route('ica.enrollment.store') }}" method="POST" enctype="multipart/form-data" id="enrollmentForm">
                        @csrf

                        <!-- Personal Information -->
                        <h4 class="mb-3 pb-2 border-bottom">Personal Information</h4>
                        <div class="alert alert-info">
                            <i class="fas fa-user"></i> <strong>Logged in as:</strong> {{ auth()->user()->name }} ({{ auth()->user()->email }})
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Surname <span class="text-danger">*</span></label>
                                <input type="text" name="surname" class="form-control @error('surname') is-invalid @enderror" value="{{ old('surname', explode(' ', auth()->user()->name)[count(explode(' ', auth()->user()->name)) - 1] ?? '') }}" required>
                                @error('surname')<div class="invalid-feedback">{{ $message }}</div>@enderror
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">First Name <span class="text-danger">*</span></label>
                                <input type="text" name="first_name" class="form-control @error('first_name') is-invalid @enderror" value="{{ old('first_name', explode(' ', auth()->user()->name)[0] ?? '') }}" required>
                                @error('first_name')<div class="invalid-feedback">{{ $message }}</div>@enderror
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Email <span class="text-danger">*</span></label>
                                <input type="email" name="email" class="form-control @error('email') is-invalid @enderror" value="{{ old('email', auth()->user()->email) }}" required readonly>
                                @error('email')<div class="invalid-feedback">{{ $message }}</div>@enderror
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Mobile <span class="text-danger">*</span></label>
                                <input type="tel" name="mobile" class="form-control @error('mobile') is-invalid @enderror" value="{{ old('mobile') }}" placeholder="+233..." required>
                                @error('mobile')<div class="invalid-feedback">{{ $message }}</div>@enderror
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-4">
                                <label class="form-label">Age <span class="text-danger">*</span></label>
                                <input type="number" name="age" class="form-control @error('age') is-invalid @enderror" value="{{ old('age') }}" min="18" max="100" required>
                                @error('age')<div class="invalid-feedback">{{ $message }}</div>@enderror
                            </div>
                            <div class="col-md-8">
                                <label class="form-label">City <span class="text-danger">*</span></label>
                                <input type="text" name="city" class="form-control @error('city') is-invalid @enderror" value="{{ old('city') }}" required>
                                @error('city')<div class="invalid-feedback">{{ $message }}</div>@enderror
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Address <span class="text-danger">*</span></label>
                            <textarea name="address" class="form-control @error('address') is-invalid @enderror" rows="2" required>{{ old('address') }}</textarea>
                            @error('address')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        </div>

                        <div class="mb-4">
                            <label class="form-label">Educational Level <span class="text-danger">*</span></label>
                            <select name="educational_level" class="form-select @error('educational_level') is-invalid @enderror" required>
                                <option value="">Select your educational level</option>
                                <option value="SHS/TVET" {{ old('educational_level') == 'SHS/TVET' ? 'selected' : '' }}>SHS/TVET</option>
                                <option value="DIPLOMA/DEGREE" {{ old('educational_level') == 'DIPLOMA/DEGREE' ? 'selected' : '' }}>DIPLOMA/DEGREE</option>
                                <option value="MASTERS" {{ old('educational_level') == 'MASTERS' ? 'selected' : '' }}>MASTERS</option>
                                <option value="OTHER" {{ old('educational_level') == 'OTHER' ? 'selected' : '' }}>OTHER</option>
                            </select>
                            @error('educational_level')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        </div>

                        <!-- Program Selection -->
                        <h4 class="mb-3 pb-2 border-bottom">Program Selection</h4>
                        <p class="text-muted mb-3">Select one or multiple programs within the same category for a structured learning experience.</p>
                        
                        @foreach($programsByCategory as $category => $programs)
                        <div class="mb-4">
                            <h5 class="fw-bold mb-3">{{ $category }}</h5>
                            @foreach($programs as $program)
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="checkbox" name="programs_of_interest[]" value="{{ $program->program_code }}" id="program_{{ $program->id }}">
                                <label class="form-check-label" for="program_{{ $program->id }}">
                                    <strong>{{ $program->program_name }}</strong> - GHS {{ number_format($program->price, 2) }}
                                </label>
                            </div>
                            @endforeach
                        </div>
                        @endforeach
                        @error('programs_of_interest')<div class="text-danger small">{{ $message }}</div>@enderror

                        <!-- Work Experience -->
                        <h4 class="mb-3 pb-2 border-bottom mt-5">Work Experience</h4>
                        <div class="mb-3">
                            <label class="form-label">Any previous experience in programs enlisted? <span class="text-danger">*</span></label>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="has_previous_experience" id="exp_yes" value="1" {{ old('has_previous_experience') == '1' ? 'checked' : '' }} required>
                                <label class="form-check-label" for="exp_yes">Yes</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="has_previous_experience" id="exp_no" value="0" {{ old('has_previous_experience') == '0' ? 'checked' : '' }} required>
                                <label class="form-check-label" for="exp_no">No</label>
                            </div>
                        </div>

                        <div class="mb-4">
                            <label class="form-label">Write A Brief Work Experience If You Have Any <span class="text-danger">*</span></label>
                            <textarea name="work_experience" class="form-control @error('work_experience') is-invalid @enderror" rows="4" placeholder="Please describe your relevant work experience, including job titles, companies, and duration..." required>{{ old('work_experience') }}</textarea>
                            <small class="text-muted">Even if you have no experience, please write "No previous experience" or describe any related activities.</small>
                            @error('work_experience')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        </div>

                        <!-- Payment Information -->
                        <h4 class="mb-3 pb-2 border-bottom mt-5">Payment Information</h4>
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i> <strong>Enrollment Fee: GHS 100.00</strong> (Expression of Interest)
                        </div>

                        <p class="mb-3">Choose your preferred payment method:</p>
                        
                        <div class="row mb-4">
                            <div class="col-md-4 mb-3">
                                <div class="payment-option" onclick="selectPayment('paystack')">
                                    <input type="radio" name="payment_method" value="paystack" id="paystack" class="form-check-input" required>
                                    <label for="paystack" class="d-block">
                                        <div class="text-center">
                                            <i class="fas fa-mobile-alt fa-3x mb-2 text-primary"></i>
                                            <h6 class="fw-bold">Mobile Money</h6>
                                            <small class="text-muted">Pay via Paystack<br>(MTN, Vodafone, AirtelTigo)</small>
                                        </div>
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-4 mb-3">
                                <div class="payment-option" onclick="selectPayment('bank_transfer')">
                                    <input type="radio" name="payment_method" value="bank_transfer" id="bank_transfer" class="form-check-input" required>
                                    <label for="bank_transfer" class="d-block">
                                        <div class="text-center">
                                            <i class="fas fa-university fa-3x mb-2 text-success"></i>
                                            <h6 class="fw-bold">Bank Transfer</h6>
                                            <small class="text-muted">Upload receipt<br>for verification</small>
                                        </div>
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-4 mb-3">
                                <div class="payment-option" onclick="selectPayment('mobile_money')">
                                    <input type="radio" name="payment_method" value="mobile_money" id="mobile_money" class="form-check-input" required>
                                    <label for="mobile_money" class="d-block">
                                        <div class="text-center">
                                            <i class="fas fa-money-bill-wave fa-3x mb-2 text-warning"></i>
                                            <h6 class="fw-bold">Direct Mobile Money</h6>
                                            <small class="text-muted">Upload screenshot<br>for verification</small>
                                        </div>
                                    </label>
                                </div>
                            </div>
                        </div>

                        <!-- Bank Receipt Upload (shown when bank_transfer or mobile_money is selected) -->
                        <div id="receiptUpload" style="display: none;">
                            <div class="mb-4">
                                <label class="form-label">Upload Payment Receipt/Screenshot <span class="text-danger">*</span></label>
                                <input type="file" name="bank_receipt" class="form-control @error('bank_receipt') is-invalid @enderror" accept=".jpg,.jpeg,.png,.pdf">
                                <small class="text-muted">Accepted formats: JPG, PNG, PDF (Max 5MB)</small>
                                @error('bank_receipt')<div class="invalid-feedback">{{ $message }}</div>@enderror
                            </div>

                            <div class="alert alert-warning">
                                <h6 class="fw-bold">Bank Details:</h6>
                                <p class="mb-1"><strong>Bank:</strong> [Bank Name]</p>
                                <p class="mb-1"><strong>Account Name:</strong> Industry Connect Academy</p>
                                <p class="mb-1"><strong>Account Number:</strong> [Account Number]</p>
                                <p class="mb-0"><strong>Mobile Money:</strong> [Mobile Money Number]</p>
                            </div>
                        </div>

                        <div class="text-center mt-4">
                            <button type="submit" class="btn btn-ghana btn-lg">
                                <i class="fas fa-paper-plane"></i> Submit Expression of Interest
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
function selectPayment(method) {
    document.querySelectorAll('.payment-option').forEach(el => el.classList.remove('active'));
    event.currentTarget.classList.add('active');
    document.getElementById(method).checked = true;
    
    const receiptUpload = document.getElementById('receiptUpload');
    if (method === 'bank_transfer' || method === 'mobile_money') {
        receiptUpload.style.display = 'block';
        receiptUpload.querySelector('input[type="file"]').required = true;
    } else {
        receiptUpload.style.display = 'none';
        receiptUpload.querySelector('input[type="file"]').required = false;
    }
}

// Form validation
document.getElementById('enrollmentForm').addEventListener('submit', function(e) {
    const programs = document.querySelectorAll('input[name="programs_of_interest[]"]:checked');
    if (programs.length === 0) {
        e.preventDefault();
        alert('Please select at least one program of interest.');
        return false;
    }
    
    const paymentMethod = document.querySelector('input[name="payment_method"]:checked');
    if (!paymentMethod) {
        e.preventDefault();
        alert('Please select a payment method.');
        return false;
    }
});
</script>
@endsection
