@extends('layouts.default')
@push('title', 'Complete Payment - ICA Enrollment')
@push('meta')@endpush
@push('css')
<style>
    .payment-container {
        min-height: 60vh;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .payment-card {
        background: white;
        padding: 40px;
        border-radius: 12px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.1);
        max-width: 500px;
        width: 100%;
    }
    .ghana-stripe {
        height: 4px;
        background: linear-gradient(to right, #CE1126, #FCD116, #006B3F);
        margin-bottom: 30px;
    }
</style>
@endpush

@section('content')
<section class="payment-container">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-6">
                <div class="payment-card">
                    <div class="ghana-stripe"></div>
                    <div class="text-center mb-4">
                        <i class="fas fa-mobile-alt fa-4x text-success mb-3"></i>
                        <h2 class="h4 fw-bold">Complete Your Payment</h2>
                        <p class="text-muted">Industry Connect Academy</p>
                    </div>

                    <div class="mb-4">
                        <div class="d-flex justify-content-between mb-2">
                            <span>Applicant:</span>
                            <strong>{{ $enrollment->first_name }} {{ $enrollment->surname }}</strong>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span>Email:</span>
                            <strong>{{ $enrollment->email }}</strong>
                        </div>
                        <div class="d-flex justify-content-between mb-3 pb-3 border-bottom">
                            <span>Enrollment Fee:</span>
                            <strong class="text-success">GHS {{ number_format($enrollment->enrollment_fee, 2) }}</strong>
                        </div>
                    </div>

                    <button type="button" class="btn btn-success btn-lg w-100" onclick="payWithPaystack()">
                        <i class="fas fa-lock"></i> Pay with Paystack
                    </button>

                    <div class="text-center mt-3">
                        <small class="text-muted">Secure payment powered by Paystack</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script src="https://js.paystack.co/v1/inline.js"></script>
<script>
function payWithPaystack() {
    var handler = PaystackPop.setup({
        key: '{{ $public_key }}',
        email: '{{ $email }}',
        amount: {{ $amount }},
        currency: 'GHS',
        ref: '{{ $reference }}',
        metadata: {
            custom_fields: [
                {
                    display_name: "Enrollment ID",
                    variable_name: "enrollment_id",
                    value: "{{ $enrollment->id }}"
                },
                {
                    display_name: "Applicant Name",
                    variable_name: "applicant_name",
                    value: "{{ $enrollment->first_name }} {{ $enrollment->surname }}"
                }
            ]
        },
        callback: function(response) {
            window.location = "{{ route('ica.payment.verify') }}?reference=" + response.reference + "&enrollment_id={{ $enrollment->id }}";
        },
        onClose: function() {
            alert('Payment window closed. You can try again when ready.');
        }
    });
    handler.openIframe();
}
</script>
@endsection
