@extends('layouts.default')
@push('title', 'Scaffolding Training Program - Industry Connect Academy')
@push('meta')
    <meta name="description" content="Professional Scaffolding Training Program at Industry Connect Academy. Intensive practical training with international standards.">
@endpush
@push('css')
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
<style>
    :root {
        --ica-primary: #11273f;
        --ica-secondary: #f2862d;
        --ica-light: #f8f9fa;
        --ica-dark: #1a1a1a;
    }

    * {
        font-family: 'Inter', sans-serif;
    }

    body {
        background: #ffffff;
    }

    .scaffolding-hero {
        background: linear-gradient(135deg, var(--ica-primary) 0%, #1a3a5f 100%);
        color: white;
        padding: 80px 0 100px;
        position: relative;
        overflow: hidden;
    }

    .scaffolding-hero::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('data:image/svg+xml,<svg width="100" height="100" xmlns="http://www.w3.org/2000/svg"><rect width="2" height="2" fill="rgba(255,255,255,0.1)"/></svg>');
        background-size: 50px 50px;
        opacity: 0.3;
    }

    .scaffolding-hero::after {
        content: '';
        position: absolute;
        bottom: -50px;
        right: -50px;
        width: 300px;
        height: 300px;
        background: var(--ica-secondary);
        border-radius: 50%;
        opacity: 0.1;
    }

    .hero-content {
        position: relative;
        z-index: 2;
    }

    .hero-badge {
        display: inline-block;
        background: var(--ica-secondary);
        color: white;
        padding: 8px 20px;
        border-radius: 50px;
        font-weight: 700;
        font-size: 0.85rem;
        letter-spacing: 1px;
        margin-bottom: 20px;
        animation: pulse 2s infinite;
    }

    @keyframes pulse {
        0%, 100% { transform: scale(1); }
        50% { transform: scale(1.05); }
    }

    .hero-title {
        font-size: 3.5rem;
        font-weight: 900;
        line-height: 1.2;
        margin-bottom: 20px;
        text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
    }

    .hero-subtitle {
        font-size: 1.5rem;
        font-weight: 600;
        color: var(--ica-secondary);
        margin-bottom: 30px;
    }

    .hero-description {
        font-size: 1.2rem;
        line-height: 1.8;
        opacity: 0.95;
        margin-bottom: 40px;
        max-width: 800px;
    }

    .hero-cta {
        display: inline-flex;
        align-items: center;
        gap: 15px;
    }

    .btn-primary-ica {
        background: var(--ica-secondary);
        color: white;
        padding: 18px 40px;
        border-radius: 50px;
        font-weight: 700;
        font-size: 1.1rem;
        text-decoration: none;
        transition: all 0.3s;
        box-shadow: 0 8px 25px rgba(242, 134, 45, 0.4);
        border: none;
    }

    .btn-primary-ica:hover {
        transform: translateY(-3px);
        box-shadow: 0 12px 35px rgba(242, 134, 45, 0.5);
        color: white;
    }

    .btn-secondary-ica {
        background: white;
        color: var(--ica-primary);
        padding: 18px 40px;
        border-radius: 50px;
        font-weight: 700;
        font-size: 1.1rem;
        text-decoration: none;
        transition: all 0.3s;
        border: 2px solid white;
    }

    .btn-secondary-ica:hover {
        background: transparent;
        color: white;
    }

    .section-title {
        font-size: 2.5rem;
        font-weight: 800;
        color: var(--ica-primary);
        margin-bottom: 15px;
        position: relative;
        display: inline-block;
    }

    .section-title::after {
        content: '';
        position: absolute;
        bottom: -10px;
        left: 0;
        width: 80px;
        height: 4px;
        background: var(--ica-secondary);
        border-radius: 2px;
    }

    .section-subtitle {
        font-size: 1.1rem;
        color: #666;
        margin-bottom: 50px;
    }

    .why-choose-section {
        padding: 80px 0;
        background: var(--ica-light);
    }

    .feature-card {
        background: white;
        border-radius: 20px;
        padding: 40px;
        height: 100%;
        box-shadow: 0 10px 40px rgba(0,0,0,0.08);
        transition: all 0.3s;
        border-left: 5px solid var(--ica-secondary);
    }

    .feature-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 20px 60px rgba(0,0,0,0.12);
    }

    .feature-icon {
        width: 80px;
        height: 80px;
        background: linear-gradient(135deg, var(--ica-primary), var(--ica-secondary));
        border-radius: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 2.5rem;
        color: white;
        margin-bottom: 25px;
        box-shadow: 0 8px 25px rgba(17, 39, 63, 0.3);
    }

    .feature-title {
        font-size: 1.4rem;
        font-weight: 700;
        color: var(--ica-primary);
        margin-bottom: 15px;
    }

    .feature-description {
        font-size: 1rem;
        color: #666;
        line-height: 1.8;
    }

    .curriculum-section {
        padding: 80px 0;
        background: white;
    }

    .curriculum-item {
        background: var(--ica-light);
        border-radius: 15px;
        padding: 30px;
        margin-bottom: 20px;
        display: flex;
        align-items: start;
        gap: 20px;
        transition: all 0.3s;
        border-left: 4px solid var(--ica-secondary);
    }

    .curriculum-item:hover {
        background: white;
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        transform: translateX(10px);
    }

    .curriculum-number {
        width: 50px;
        height: 50px;
        background: linear-gradient(135deg, var(--ica-primary), var(--ica-secondary));
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 800;
        font-size: 1.3rem;
        color: white;
        flex-shrink: 0;
    }

    .curriculum-content h5 {
        font-size: 1.2rem;
        font-weight: 700;
        color: var(--ica-primary);
        margin-bottom: 8px;
    }

    .curriculum-content p {
        font-size: 1rem;
        color: #666;
        margin: 0;
    }

    .cta-section {
        padding: 80px 0;
        background: linear-gradient(135deg, var(--ica-primary) 0%, #1a3a5f 100%);
        color: white;
        text-align: center;
        position: relative;
        overflow: hidden;
    }

    .cta-section::before {
        content: '';
        position: absolute;
        top: -100px;
        left: -100px;
        width: 300px;
        height: 300px;
        background: var(--ica-secondary);
        border-radius: 50%;
        opacity: 0.1;
    }

    .cta-section::after {
        content: '';
        position: absolute;
        bottom: -100px;
        right: -100px;
        width: 300px;
        height: 300px;
        background: var(--ica-secondary);
        border-radius: 50%;
        opacity: 0.1;
    }

    .cta-content {
        position: relative;
        z-index: 2;
    }

    .cta-badge {
        display: inline-block;
        background: var(--ica-secondary);
        color: white;
        padding: 12px 30px;
        border-radius: 50px;
        font-weight: 700;
        font-size: 1rem;
        letter-spacing: 1px;
        margin-bottom: 30px;
        animation: pulse 2s infinite;
    }

    .cta-title {
        font-size: 3rem;
        font-weight: 900;
        margin-bottom: 20px;
    }

    .cta-subtitle {
        font-size: 1.3rem;
        margin-bottom: 40px;
        opacity: 0.95;
    }

    .contact-section {
        padding: 80px 0;
        background: var(--ica-light);
    }

    .contact-card {
        background: white;
        border-radius: 20px;
        padding: 40px;
        text-align: center;
        box-shadow: 0 10px 40px rgba(0,0,0,0.08);
        transition: all 0.3s;
        height: 100%;
    }

    .contact-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 50px rgba(0,0,0,0.12);
    }

    .contact-icon {
        width: 70px;
        height: 70px;
        background: linear-gradient(135deg, var(--ica-primary), var(--ica-secondary));
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 2rem;
        color: white;
        margin: 0 auto 20px;
    }

    .contact-title {
        font-size: 1.3rem;
        font-weight: 700;
        color: var(--ica-primary);
        margin-bottom: 15px;
    }

    .contact-info {
        font-size: 1.1rem;
        color: #666;
    }

    .contact-info a {
        color: var(--ica-secondary);
        text-decoration: none;
        font-weight: 600;
    }

    .contact-info a:hover {
        text-decoration: underline;
    }

    .social-links {
        display: flex;
        justify-content: center;
        gap: 20px;
        margin-top: 30px;
    }

    .social-link {
        width: 60px;
        height: 60px;
        background: linear-gradient(135deg, var(--ica-primary), var(--ica-secondary));
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 1.5rem;
        text-decoration: none;
        transition: all 0.3s;
        box-shadow: 0 5px 20px rgba(17, 39, 63, 0.3);
    }

    .social-link:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(242, 134, 45, 0.4);
        color: white;
    }

    .stats-section {
        background: white;
        padding: 60px 0;
        border-top: 3px solid var(--ica-secondary);
        border-bottom: 3px solid var(--ica-secondary);
    }

    .stat-item {
        text-align: center;
        padding: 20px;
    }

    .stat-number {
        font-size: 3.5rem;
        font-weight: 900;
        color: var(--ica-secondary);
        display: block;
        margin-bottom: 10px;
    }

    .stat-label {
        font-size: 1.1rem;
        color: var(--ica-primary);
        font-weight: 600;
    }

    @media (max-width: 991px) {
        .hero-title {
            font-size: 2.5rem;
        }
        .section-title {
            font-size: 2rem;
        }
        .cta-title {
            font-size: 2rem;
        }
    }

    @media (max-width: 767px) {
        .hero-title {
            font-size: 2rem;
        }
        .hero-cta {
            flex-direction: column;
            width: 100%;
        }
        .btn-primary-ica,
        .btn-secondary-ica {
            width: 100%;
            text-align: center;
            justify-content: center;
        }
    }
</style>
@endpush

@section('content')
<!-- Hero Section -->
<section class="scaffolding-hero">
    <div class="container">
        <div class="hero-content">
            <span class="hero-badge">PROFESSIONAL CERTIFICATE COURSE</span>
            <h1 class="hero-title">SCAFFOLDING TRAINING PROGRAM</h1>
            <p class="hero-subtitle">Boost Your Skills for In-Demand Careers in Oil, Gas, Construction & Manufacturing!</p>
            <p class="hero-description">
                Intensive practical training with real scaffolding materials and structures. Expert guidance on international standards (e.g., OSHA-aligned, CISRS-inspired)
            </p>
            <div class="hero-cta">
                <a href="{{ route('ica.enrollment') }}" class="btn-primary-ica">
                    <i class="fas fa-file-alt me-2"></i> Apply Now
                </a>
                <a href="#curriculum" class="btn-secondary-ica">
                    <i class="fas fa-book me-2"></i> View Curriculum
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Stats Section -->
<section class="stats-section">
    <div class="container">
        <div class="row">
            <div class="col-md-3 col-6">
                <div class="stat-item">
                    <span class="stat-number">100%</span>
                    <span class="stat-label">Practical Training</span>
                </div>
            </div>
            <div class="col-md-3 col-6">
                <div class="stat-item">
                    <span class="stat-number">4-6</span>
                    <span class="stat-label">Weeks Duration</span>
                </div>
            </div>
            <div class="col-md-3 col-6">
                <div class="stat-item">
                    <span class="stat-number">Expert</span>
                    <span class="stat-label">Instructors</span>
                </div>
            </div>
            <div class="col-md-3 col-6">
                <div class="stat-item">
                    <span class="stat-number">2026</span>
                    <span class="stat-label">Intake Open</span>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Why Choose Section -->
<section class="why-choose-section">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="section-title">Why Choose ICA's Scaffolding Training?</h2>
            <p class="section-subtitle">Africa's Future of Technical Competence</p>
        </div>
        <div class="row g-4">
            <div class="col-lg-3 col-md-6">
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-tools"></i>
                    </div>
                    <h4 class="feature-title">Hands-On Training</h4>
                    <p class="feature-description">Work with real scaffolding materials and structures in our state-of-the-art training facility.</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-globe"></i>
                    </div>
                    <h4 class="feature-title">International Standards</h4>
                    <p class="feature-description">Training aligned with OSHA standards and CISRS-inspired best practices.</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-user-tie"></i>
                    </div>
                    <h4 class="feature-title">Expert Instructors</h4>
                    <p class="feature-description">Learn from industry professionals with years of practical experience.</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-certificate"></i>
                    </div>
                    <h4 class="feature-title">Professional Certificate</h4>
                    <p class="feature-description">Earn a recognized certificate upon successful completion of the program.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Curriculum Section -->
<section class="curriculum-section" id="curriculum">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="section-title">What Will You Learn</h2>
            <p class="section-subtitle">Comprehensive curriculum covering all aspects of scaffolding</p>
        </div>
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="curriculum-item">
                    <div class="curriculum-number">1</div>
                    <div class="curriculum-content">
                        <h5>Scaffolding Types and Configurations</h5>
                        <p>Master different scaffolding systems including tube and fitting, system scaffolds, and mobile access towers.</p>
                    </div>
                </div>
                <div class="curriculum-item">
                    <div class="curriculum-number">2</div>
                    <div class="curriculum-content">
                        <h5>Safety Harnessing and Fall Protection</h5>
                        <p>Learn proper use of personal protective equipment and fall arrest systems to ensure workplace safety.</p>
                    </div>
                </div>
                <div class="curriculum-item">
                    <div class="curriculum-number">3</div>
                    <div class="curriculum-content">
                        <h5>Risk Assessments and Site Inspections</h5>
                        <p>Develop skills in identifying hazards, conducting risk assessments, and performing thorough site inspections.</p>
                    </div>
                </div>
                <div class="curriculum-item">
                    <div class="curriculum-number">4</div>
                    <div class="curriculum-content">
                        <h5>International HSE Standards and Compliance</h5>
                        <p>Understand and apply international health, safety, and environmental standards in scaffolding operations.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="cta-section">
    <div class="container">
        <div class="cta-content">
            <span class="cta-badge">LIMITED SEATS AVAILABLE!</span>
            <h2 class="cta-title">SECURE YOUR SPOT FOR THE 2026 INTAKE</h2>
            <p class="cta-subtitle">Don't miss this opportunity to advance your career in the construction industry</p>
            <a href="{{ route('ica.enrollment') }}" class="btn-primary-ica btn-lg">
                <i class="fas fa-rocket me-2"></i> Apply Now - Limited Seats!
            </a>
        </div>
    </div>
</section>

<!-- Contact Section -->
<section class="contact-section">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="section-title">Get In Touch</h2>
            <p class="section-subtitle">Contact us for more information about the program</p>
        </div>
        <div class="row g-4">
            <div class="col-lg-4 col-md-6">
                <div class="contact-card">
                    <div class="contact-icon">
                        <i class="fas fa-phone"></i>
                    </div>
                    <h4 class="contact-title">Call Us</h4>
                    <p class="contact-info">
                        <a href="tel:+233546273013">+233 (0)54 627 3013</a>
                    </p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="contact-card">
                    <div class="contact-icon">
                        <i class="fas fa-globe"></i>
                    </div>
                    <h4 class="contact-title">Visit Website</h4>
                    <p class="contact-info">
                        <a href="https://www.myicagh.com" target="_blank">www.myicagh.com</a>
                    </p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="contact-card">
                    <div class="contact-icon">
                        <i class="fas fa-envelope"></i>
                    </div>
                    <h4 class="contact-title">Email Us</h4>
                    <p class="contact-info">
                        <a href="mailto:{{ get_settings('system_email') }}">{{ get_settings('system_email') }}</a>
                    </p>
                </div>
            </div>
        </div>

        <!-- Social Media Links -->
        <div class="text-center mt-5">
            <h4 class="mb-4" style="color: var(--ica-primary); font-weight: 700;">Follow Us on Social Media</h4>
            <div class="social-links">
                <a href="https://web.facebook.com/industryconnectacademy" target="_blank" class="social-link" title="Facebook">
                    <i class="fab fa-facebook-f"></i>
                </a>
                <a href="https://www.instagram.com/industry_connect_academy/" target="_blank" class="social-link" title="Instagram">
                    <i class="fab fa-instagram"></i>
                </a>
                <a href="{{ get_frontend_settings('linkedin') }}" target="_blank" class="social-link" title="LinkedIn">
                    <i class="fab fa-linkedin-in"></i>
                </a>
                <a href="{{ get_frontend_settings('twitter') }}" target="_blank" class="social-link" title="Twitter">
                    <i class="fab fa-twitter"></i>
                </a>
            </div>
        </div>
    </div>
</section>
@endsection

@push('js')
<script>
    "use strict";
    
    // Smooth scroll for anchor links
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });
</script>
@endpush
