@extends('layouts.default')
@push('title', 'Enrollment Successful - ICA')
@push('meta')@endpush
@push('css')
<style>
    .success-container {
        min-height: 70vh;
        display: flex;
        align-items: center;
        justify-content: center;
        background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
    }
    .success-card {
        background: white;
        padding: 50px;
        border-radius: 12px;
        box-shadow: 0 8px 30px rgba(0,0,0,0.1);
        max-width: 700px;
        width: 100%;
    }
    .ghana-flag-border {
        border-top: 4px solid #CE1126;
        border-bottom: 4px solid #006B3F;
        padding: 20px 0;
    }
    .success-icon {
        width: 80px;
        height: 80px;
        background: linear-gradient(135deg, #006B3F 0%, #00a651 100%);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 20px;
    }
    .program-badge {
        background: #f8f9fa;
        padding: 10px 15px;
        border-radius: 8px;
        border-left: 3px solid #006B3F;
        margin-bottom: 10px;
    }
</style>
@endpush

@section('content')
<section class="success-container">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="success-card">
                    <div class="text-center mb-4">
                        <div class="success-icon">
                            <i class="fas fa-check fa-3x text-white"></i>
                        </div>
                        <h1 class="h2 fw-bold mb-2">Expression of Interest Submitted Successfully!</h1>
                        <p class="text-muted">Thank you for your interest in Industry Connect Academy</p>
                    </div>

                    <div class="ghana-flag-border mb-4">
                        <div class="row text-center">
                            <div class="col-md-4 mb-3">
                                <div class="h3 fw-bold text-success mb-1">
                                    @if($enrollment->payment_status === 'paid')
                                        <i class="fas fa-check-circle"></i>
                                    @else
                                        <i class="fas fa-clock"></i>
                                    @endif
                                </div>
                                <small class="text-muted">Payment Status</small>
                                <div class="fw-bold">
                                    @if($enrollment->payment_status === 'paid')
                                        <span class="text-success">Paid</span>
                                    @else
                                        <span class="text-warning">Pending Verification</span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-4 mb-3">
                                <div class="h3 fw-bold text-primary mb-1"><i class="fas fa-user-graduate"></i></div>
                                <small class="text-muted">Applicant</small>
                                <div class="fw-bold">{{ $enrollment->first_name }} {{ $enrollment->surname }}</div>
                            </div>
                            <div class="col-md-4 mb-3">
                                <div class="h3 fw-bold text-info mb-1"><i class="fas fa-envelope"></i></div>
                                <small class="text-muted">Email</small>
                                <div class="fw-bold small">{{ $enrollment->email }}</div>
                            </div>
                        </div>
                    </div>

                    <div class="mb-4">
                        <h5 class="fw-bold mb-3">Selected Programs:</h5>
                        @foreach($enrollment->programs() as $program)
                        <div class="program-badge">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <strong>{{ $program->program_name }}</strong>
                                    <br>
                                    <small class="text-muted">{{ $program->category }}</small>
                                </div>
                                <div class="text-end">
                                    <strong class="text-success">GHS {{ number_format($program->price, 2) }}</strong>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>

                    <div class="alert alert-info">
                        <h6 class="fw-bold mb-2"><i class="fas fa-info-circle"></i> What's Next?</h6>
                        <ul class="mb-0">
                            <li>You will receive a confirmation email at <strong>{{ $enrollment->email }}</strong></li>
                            @if($enrollment->payment_status === 'paid')
                                <li>A formal application letter will be sent within 24-48 hours</li>
                                <li>The letter will include program requirements, admission details, PPE requirements, and next steps</li>
                            @else
                                <li>Your payment receipt is being verified by our admin team</li>
                                <li>Once verified, you will receive a formal application letter within 24-48 hours</li>
                                <li>The letter will include program requirements, admission details, PPE requirements, and payment confirmation</li>
                            @endif
                            <li>Please check your email regularly (including spam folder)</li>
                        </ul>
                    </div>

                    <div class="alert alert-success">
                        <h6 class="fw-bold mb-2"><i class="fas fa-graduation-cap"></i> Enrollment Details</h6>
                        <div class="row">
                            <div class="col-md-6">
                                <small class="text-muted">Enrollment ID:</small>
                                <div class="fw-bold">ICA-{{ str_pad($enrollment->id, 6, '0', STR_PAD_LEFT) }}</div>
                            </div>
                            <div class="col-md-6">
                                <small class="text-muted">Submission Date:</small>
                                <div class="fw-bold">{{ $enrollment->created_at->format('d M Y, h:i A') }}</div>
                            </div>
                        </div>
                    </div>

                    <div class="text-center mt-4">
                        <a href="{{ route('home') }}" class="btn btn-primary btn-lg">
                            <i class="fas fa-home"></i> Return to Home
                        </a>
                        <button onclick="window.print()" class="btn btn-outline-secondary btn-lg">
                            <i class="fas fa-print"></i> Print Confirmation
                        </button>
                    </div>

                    <div class="text-center mt-4">
                        <p class="text-muted small mb-0">
                            For inquiries, contact us at: <strong>info@icaghana.com</strong> | <strong>+233 XX XXX XXXX</strong>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
