<?php $__env->startPush('title', get_phrase('Bootcamp Manager')); ?>
<?php $__env->startSection('content'); ?>
    <div class="ol-card radius-8px">
        <div class="ol-card-body py-12px px-20px my-3">
            <div class="d-flex align-items-center justify-content-between flex-md-nowrap flex-wrap gap-3">
                <h4 class="title fs-16px">
                    <i class="fi-rr-settings-sliders me-2"></i>
                    <?php echo e(get_phrase('Manage Bootcamp')); ?>

                </h4>

                <a href="<?php echo e(route('admin.bootcamp.create')); ?>"class="btn ol-btn-outline-secondary d-flex align-items-center cg-10px">
                    <span class="fi-rr-plus"></span>
                    <span><?php echo e(get_phrase('Add New Bootcamp')); ?></span>
                </a>
            </div>
        </div>
    </div>


    <!-- Start Admin area -->
    <div class="row">
        <div class="col-12">
            <div class="ol-card">
                <div class="ol-card-body mb-5 p-3">
                    <div class="row mb-4 mt-3">
                        <div class="col-md-6 d-flex align-items-center gap-3">
                            <div class="custom-dropdown ms-2">
                                <button class="dropdown-header btn ol-btn-light">
                                    <?php echo e(get_phrase('Export')); ?>

                                    <i class="fi-rr-file-export ms-2"></i>
                                </button>
                                <ul class="dropdown-list">
                                    <li>
                                        <a class="dropdown-item export-btn" href="#" onclick="downloadPDF('.print-table', 'bootcamp-list')"><i class="fi-rr-file-pdf"></i> <?php echo e(get_phrase('PDF')); ?></a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item export-btn" href="#" onclick="window.print();"><i class="fi-rr-print"></i> <?php echo e(get_phrase('Print')); ?></a>
                                    </li>
                                </ul>
                            </div>

                            <div class="custom-dropdown dropdown-filter <?php if(!isset($_GET) || (isset($_GET) && count($_GET) == 0)): ?>  <?php endif; ?>">
                                <button class="dropdown-header btn ol-btn-light">
                                    <i class="fi-rr-filter me-2"></i>
                                    <?php echo e(get_phrase('Filter')); ?>


                                    <span class="text-12px"> (4)</span>
                                </button>
                                <ul class="dropdown-list w-250px">
                                    <li>
                                        <form id="filter-dropdown" action="<?php echo e(route('admin.bootcamps', ['type' => request()->route()->parameter('type')])); ?>" method="get">
                                            <input type="hidden" name="search" value="<?php echo e(request('search')); ?>">
                                            <div class="filter-option d-flex flex-column gap-3">
                                                <div>
                                                    <label for="eDataList" class="form-label ol-form-label"><?php echo e(get_phrase('Category')); ?></label>
                                                    <select class="form-control ol-form-control ol-select2" data-toggle="select2" name="category" data-placeholder="Type to search...">
                                                        <option value="all"><?php echo e(get_phrase('All')); ?></option>

                                                        <?php $__currentLoopData = App\Models\BootcampCategory::orderBy('title', 'asc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($category->slug); ?>" <?php if(request('category') == $category->slug): ?> selected <?php endif; ?>>
                                                                <?php echo e($category->title); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                                <div>
                                                    <label for="eDataList" class="form-label ol-form-label"><?php echo e(get_phrase('Status')); ?></label>
                                                    <select class="form-control ol-form-control ol-select2" data-toggle="select2" name="status" class="ol-select-2" data-placeholder="Type to search...">
                                                        <option value="all"><?php echo e(get_phrase('All')); ?>

                                                        </option>

                                                        <option value="active"<?php if(request('status') == 'active'): ?> selected <?php endif; ?>>
                                                            <?php echo e(get_phrase('Active')); ?> </option>
                                                        <option value="inactive"<?php if(request('status') == 'inactive'): ?> selected <?php endif; ?>>
                                                            <?php echo e(get_phrase('Inactive')); ?> </option>
                                                    </select>
                                                </div>

                                                <div>
                                                    <label for="eDataList" class="form-label ol-form-label"><?php echo e(get_phrase('Instructor')); ?></label>
                                                    <select class="form-control ol-form-control ol-select2" data-toggle="select2" name="instructor" class="ol-select-2" data-placeholder="Type to search...">
                                                        <option value="all"><?php echo e(get_phrase('All')); ?>

                                                        </option>
                                                        <?php $__currentLoopData = App\Models\Course::select('user_id')->distinct()->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($course->user_id); ?>"<?php if(request('instructor') == $course->user_id): ?> selected <?php endif; ?>>
                                                                <?php echo e(ucfirst(get_user_info($course->user_id)->name)); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                                <div>
                                                    <label for="eDataList" class="form-label ol-form-label"><?php echo e(get_phrase('Price')); ?></label>
                                                    <select class="form-control ol-form-control ol-select2" data-toggle="select2" name="price" class="ol-select-2" data-placeholder="Type to search...">
                                                        <option value="all"><?php echo e(get_phrase('All')); ?>

                                                        </option>

                                                        <option value="free"<?php if(request('price') == 'free'): ?> selected <?php endif; ?>>
                                                            <?php echo e(get_phrase('Free')); ?></option>
                                                        <option value="discounted"<?php if(request('price') == 'discounted'): ?> selected <?php endif; ?>>
                                                            <?php echo e(get_phrase('Discounted')); ?></option>
                                                        <option value="paid"<?php if(request('price') == 'paid'): ?> selected <?php endif; ?>>
                                                            <?php echo e(get_phrase('Paid')); ?></option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="filter-button d-flex justify-content-end align-items-center mt-3">
                                                <button type="submit" class="ol-btn-primary"><?php echo e(get_phrase('Apply')); ?></button>
                                            </div>
                                        </form>
                                    </li>
                                </ul>
                            </div>

                            <?php if(isset($_GET) && count($_GET) > 0): ?>
                                <a href="<?php echo e(route('admin.bootcamps', ['type' => request()->route()->parameter('type')])); ?>" class="me-2" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Clear')); ?>"><i class="fi-rr-cross-circle"></i></a>
                            <?php endif; ?>
                        </div>
                        <div class="col-md-6 mt-md-0 mt-3">
                            <form action="<?php echo e(route('admin.bootcamps', ['type' => request()->route()->parameter('type')])); ?>" method="get">

                                <?php
                                    $queries = request()->query();
                                    unset($queries['search']);
                                ?>
                                <div class="row">
                                    <div class="col-9">
                                        <div class="search-input flex-grow-1">
                                            <input type="text" name="search" value="<?php echo e(request('search')); ?>" placeholder="<?php echo e(get_phrase('Search Title')); ?>" class="ol-form-control form-control" />
                                        </div>
                                    </div>
                                    <div class="col-3">
                                        <button type="submit" class="btn ol-btn-primary w-100" id="submit-button"><?php echo e(get_phrase('Search')); ?></button>
                                    </div>
                                </div>
                                <?php $__currentLoopData = $queries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $query): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <input type="hidden" name="<?php echo e($key); ?>" value="<?php echo e($query); ?>">
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </form>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <?php if($bootcamps->count() > 0): ?>
                                <div class="admin-tInfo-pagi d-flex justify-content-md-between justify-content-center align-items-center gr-15 flex-wrap">
                                    <p class="admin-tInfo">
                                        <?php echo e(get_phrase('Showing') . ' ' . count($bootcamps) . ' ' . get_phrase('of') . ' ' . $bootcamps->total() . ' ' . get_phrase('data')); ?>

                                    </p>
                                </div>
                                <div class="table-responsive course_list overflow-auto overflow-auto" id="course_list">
                                    <table class="eTable eTable-2 print-table table">
                                        <thead>
                                            <tr>
                                                <th scope="col">#</th>
                                                <th scope="col"><?php echo e(get_phrase('Title')); ?></th>
                                                <th scope="col"><?php echo e(get_phrase('Category')); ?></th>
                                                <th scope="col"><?php echo e(get_phrase('Module & Class')); ?></th>
                                                <th scope="col"><?php echo e(get_phrase('Enrolled Student')); ?></th>
                                                <th scope="col" class="print-d-none"><?php echo e(get_phrase('Status')); ?></th>
                                                <th scope="col"><?php echo e(get_phrase('Price')); ?></th>
                                                <th scope="col" class="print-d-none"><?php echo e(get_phrase('Options')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $bootcamps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $bootcamp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <th scope="row">
                                                        <p class="row-number"><?php echo e(++$key); ?></p>
                                                    </th>
                                                    <td>
                                                        <div class="dAdmin_profile d-flex align-items-center min-w-200px">
                                                            <div class="dAdmin_profile_name">
                                                                <h4 class="title fs-14px">
                                                                    <a href="<?php echo e(route('admin.bootcamp.edit', [$bootcamp->id, 'tab' => 'curriculum'])); ?>"><?php echo e(ucfirst($bootcamp->title)); ?></a>
                                                                </h4>

                                                                <a href="<?php echo e(route('admin.bootcamps', ['instructor' => $bootcamp->user_id])); ?>">
                                                                    <p class="sub-title2 text-12px">
                                                                        <?php echo e(get_phrase('Instructor')); ?>:
                                                                        <?php echo e(get_user_info($bootcamp->user_id)->name); ?></p>
                                                                    <p class="sub-title2 text-12px">
                                                                        <?php echo e(get_phrase('Email')); ?>:
                                                                        <?php echo e(get_user_info($bootcamp->user_id)->email); ?></p>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="sub-title2 text-12px">
                                                            <a href="<?php echo e(route('admin.bootcamps', ['category' => $bootcamp->category_slug])); ?>"><?php echo e($bootcamp->category); ?></a>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="sub-title2 text-12px">
                                                            <a href="<?php echo e(route('admin.bootcamp.edit', [$bootcamp->id, 'tab' => 'curriculum'])); ?>">
                                                                <p><?php echo e(get_phrase('Module')); ?>:
                                                                    <?php echo e(count_bootcamp_modules($bootcamp->id)); ?> </p>
                                                                <p> <?php echo e(get_phrase('Class')); ?>:
                                                                    <?php echo e(count_bootcamp_classes($bootcamp->id)); ?> </p>
                                                            </a>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="sub-title2 text-12px">
                                                            <p><?php echo e(get_phrase('Enrollments')); ?>:
                                                                <?php echo e(bootcamp_enrolls($bootcamp->id)); ?>

                                                            </p>
                                                        </div>
                                                    </td>
                                                    <td class="print-d-none">
                                                        <span class="badge bg-<?php echo e($bootcamp->status ? 'active' : 'inactive'); ?>"><?php echo e(get_phrase($bootcamp->status ? 'Active' : 'Inactive')); ?></span>
                                                    </td>
                                                    <td>
                                                        <div class="dAdmin_info_name min-w-150px">
                                                            <?php if($bootcamp->is_paid == 0): ?>
                                                                <p class="eBadge ebg-soft-success">
                                                                    <?php echo e(get_phrase('Free')); ?>

                                                                </p>
                                                            <?php else: ?>
                                                                <p><?php echo e(currency($bootcamp->price - $bootcamp->discounted_price)); ?>

                                                                </p>
                                                            <?php endif; ?>
                                                        </div>
                                                    </td>
                                                    <td class="print-d-none">
                                                        <div class="dropdown ol-icon-dropdown ol-icon-dropdown-transparent">
                                                            <button class="btn ol-btn-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                                <span class="fi-rr-menu-dots-vertical"></span>
                                                            </button>

                                                            <ul class="dropdown-menu">
                                                                <li>
                                                                    <a class="dropdown-item" target="_blank" href="<?php echo e(route('bootcamp.details', $bootcamp->slug)); ?>"><?php echo e(get_phrase('Frontend View')); ?></a>
                                                                </li>
                                                                <li>
                                                                    <a class="dropdown-item" href="<?php echo e(route('admin.bootcamp.edit', [$bootcamp->id, 'tab' => 'basic'])); ?>"><?php echo e(get_phrase('Edit')); ?></a>
                                                                </li>
                                                                <?php if($bootcamp->status): ?>
                                                                    <li>
                                                                        <a class="dropdown-item" onclick="confirmModal('<?php echo e(route('admin.bootcamp.status', ['id' => $bootcamp->id])); ?>')" href="javascript:void(0)"><?php echo e(get_phrase('Make As Inactive')); ?></a>
                                                                    </li>
                                                                <?php else: ?>
                                                                    <li>
                                                                        <a class="dropdown-item" onclick="confirmModal('<?php echo e(route('admin.bootcamp.status', ['id' => $bootcamp->id])); ?>')" href="javascript:void(0)"><?php echo e(get_phrase('Make As Active')); ?></a>
                                                                    </li>
                                                                <?php endif; ?>
                                                                <li>
                                                                    <a class="dropdown-item" onclick="confirmModal('<?php echo e(route('admin.bootcamp.duplicate', $bootcamp->id)); ?>')" href="javascript:void(0)"><?php echo e(get_phrase('Duplicate')); ?></a>
                                                                </li>
                                                                <li>
                                                                    <a class="dropdown-item" onclick="confirmModal('<?php echo e(route('admin.bootcamp.delete', $bootcamp->id)); ?>')" href="javascript:void(0)"><?php echo e(get_phrase('Delete')); ?></a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="admin-tInfo-pagi d-flex justify-content-md-between justify-content-center align-items-center gr-15 flex-wrap">
                                    <p class="admin-tInfo">
                                        <?php echo e(get_phrase('Showing') . ' ' . count($bootcamps) . ' ' . get_phrase('of') . ' ' . $bootcamps->total() . ' ' . get_phrase('data')); ?>

                                    </p>
                                    <?php echo e($bootcamps->links()); ?>

                                </div>
                            <?php else: ?>
                                <?php echo $__env->make('admin.no_data', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Admin area -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/onlinecourse/resources/views/admin/bootcamp/index.blade.php ENDPATH**/ ?>